/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.writer;

import java.io.IOException;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.IndexWriterPool;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledLuceneIndexWriter
implements LuceneIndexWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PooledLuceneIndexWriter.class);
    private final String indexName;
    private final LuceneIndexWriter delegateWriter;
    private final IndexWriterPool writerPool;
    private long updateCount = 0L;
    private long deleteCount = 0L;

    public PooledLuceneIndexWriter(IndexWriterPool writerPool, LuceneIndexWriter delegateWriter, String indexName) {
        this.writerPool = writerPool;
        this.delegateWriter = delegateWriter;
        this.indexName = indexName;
        LOG.debug("[{}] Created writer", (Object)indexName);
    }

    @Override
    public void updateDocument(String path, Iterable<? extends IndexableField> doc) throws IOException {
        this.writerPool.updateDocument(this.delegateWriter, path, doc);
        ++this.updateCount;
    }

    @Override
    public void deleteDocuments(String path) throws IOException {
        this.writerPool.deleteDocuments(this.delegateWriter, path);
        ++this.deleteCount;
    }

    @Override
    public boolean close(long timestamp) throws IOException {
        LOG.debug("[{}] Shutting down writer", (Object)this.indexName);
        return this.writerPool.closeWriter(this.delegateWriter, timestamp);
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public long getDeleteCount() {
        return this.deleteCount;
    }

    public String formatStatistics() {
        return "PooledLuceneIndexWriter(" + this.indexName + ")[updates: " + this.updateCount + ", deletes: " + this.deleteCount + "]";
    }
}

