/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.writer;

import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexWriterConfig {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneIndexWriterConfig.class);
    public static final String MAX_BUFFERED_DELETE_TERMS_KEY = "oak.index.lucene.maxBufferedDeleteTerms";
    public static final String RAM_PER_THREAD_HARD_LIMIT_MB_KEY = "oak.index.lucene.ramPerThreadHardLimitMB";
    private final int maxBufferedDeleteTerms = (Integer)SystemPropertySupplier.create((String)"oak.index.lucene.maxBufferedDeleteTerms", (Object)-1).loggingTo(LOG).get();
    private final int ramPerThreadHardLimitMB = (Integer)SystemPropertySupplier.create((String)"oak.index.lucene.ramPerThreadHardLimitMB", (Object)1945).loggingTo(LOG).get();
    private final double ramBufferSizeMB;
    private final int threadCount;

    public LuceneIndexWriterConfig() {
        this(16.0);
    }

    public LuceneIndexWriterConfig(double ramBufferSizeMB) {
        this.ramBufferSizeMB = ramBufferSizeMB;
        this.threadCount = 1;
    }

    public LuceneIndexWriterConfig(double ramBufferSizeMB, int threadCount) {
        this.ramBufferSizeMB = ramBufferSizeMB;
        this.threadCount = threadCount;
    }

    public double getRamBufferSizeMB() {
        return this.ramBufferSizeMB;
    }

    public int getMaxBufferedDeleteTerms() {
        return this.maxBufferedDeleteTerms;
    }

    public int getRamPerThreadHardLimitMB() {
        return this.ramPerThreadHardLimitMB;
    }

    public int getThreadCount() {
        return this.threadCount;
    }
}

