/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.writer;

import java.util.HashMap;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SuggestHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.fv.LSHAnalyzer;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriterConfig;
import org.apache.jackrabbit.oak.plugins.index.search.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.shingle.ShingleAnalyzerWrapper;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SerialMergeScheduler;

public class IndexWriterUtils {
    private static final int INDEX_WRITER_MAX_MERGE = Integer.getInteger("oak.indexer.writerMaxMerges", 1);
    private static final int INDEX_WRITER_MAX_THREAD = Integer.getInteger("oak.indexer.writerMaxThreads", 1);

    public static IndexWriterConfig getIndexWriterConfig(LuceneIndexDefinition definition, boolean serialScheduler) {
        return IndexWriterUtils.getIndexWriterConfig(definition, serialScheduler, new LuceneIndexWriterConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexWriterConfig getIndexWriterConfig(LuceneIndexDefinition definition, boolean serialScheduler, LuceneIndexWriterConfig writerConfig) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(IndexWriterConfig.class.getClassLoader());
        try {
            Analyzer definitionAnalyzer = definition.getAnalyzer();
            HashMap<String, Analyzer> analyzers = new HashMap<String, Analyzer>();
            analyzers.put(":spellcheck", new ShingleAnalyzerWrapper(LuceneIndexConstants.ANALYZER, 3));
            for (IndexDefinition.IndexingRule r : definition.getDefinedRules()) {
                List<PropertyDefinition> similarityProperties = r.getSimilarityProperties();
                for (PropertyDefinition pd : similarityProperties) {
                    if (!pd.useInSimilarity) continue;
                    analyzers.put(FieldNames.createSimilarityFieldName(pd.name), new LSHAnalyzer());
                }
            }
            if (!definition.isSuggestAnalyzed()) {
                analyzers.put(":suggest", SuggestHelper.getAnalyzer());
            }
            PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper(definitionAnalyzer, analyzers);
            IndexWriterConfig config = new IndexWriterConfig(LuceneIndexConstants.VERSION, analyzer);
            if (serialScheduler) {
                config.setMergeScheduler(new SerialMergeScheduler());
            } else {
                ConcurrentMergeScheduler concurrentMergeScheduler = new ConcurrentMergeScheduler();
                concurrentMergeScheduler.setMaxMergesAndThreads(INDEX_WRITER_MAX_MERGE, INDEX_WRITER_MAX_THREAD);
                config.setMergeScheduler(concurrentMergeScheduler);
            }
            if (definition.getCodec() != null) {
                config.setCodec(definition.getCodec());
            }
            config.setRAMBufferSizeMB(writerConfig.getRamBufferSizeMB());
            config.setMaxBufferedDeleteTerms(writerConfig.getMaxBufferedDeleteTerms());
            config.setRAMPerThreadHardLimitMB(writerConfig.getRamPerThreadHardLimitMB());
            IndexWriterConfig indexWriterConfig = config;
            return indexWriterConfig;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }
}

