/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.writer;

import java.util.Objects;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexWriterFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.DefaultIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.IndexWriterPool;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriterConfig;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.MultiplexingIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.PooledLuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexWriterFactory
implements LuceneIndexWriterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIndexWriterFactory.class);
    private final MountInfoProvider mountInfoProvider;
    private final DirectoryFactory directoryFactory;
    private final LuceneIndexWriterConfig writerConfig;
    private final IndexWriterPool indexWriterPool;

    public DefaultIndexWriterFactory(MountInfoProvider mountInfoProvider, DirectoryFactory directoryFactory, LuceneIndexWriterConfig writerConfig) {
        this(mountInfoProvider, directoryFactory, writerConfig, null);
    }

    public DefaultIndexWriterFactory(MountInfoProvider mountInfoProvider, DirectoryFactory directoryFactory, LuceneIndexWriterConfig writerConfig, IndexWriterPool indexWriterPool) {
        this.mountInfoProvider = Objects.requireNonNull(mountInfoProvider);
        this.directoryFactory = Objects.requireNonNull(directoryFactory);
        this.writerConfig = Objects.requireNonNull(writerConfig);
        this.indexWriterPool = indexWriterPool;
    }

    @Override
    public LuceneIndexWriter newInstance(IndexDefinition def, NodeBuilder definitionBuilder, CommitInfo commitInfo, boolean reindex) {
        Validate.checkArgument((boolean)(def instanceof LuceneIndexDefinition), (String)"Expected %s but found %s for index definition", (Object[])new Object[]{LuceneIndexDefinition.class, def.getClass()});
        LuceneIndexDefinition definition = (LuceneIndexDefinition)def;
        if (this.mountInfoProvider.hasNonDefaultMounts()) {
            return this.wrapWithPipelinedIndexWriter(new MultiplexingIndexWriter(this.directoryFactory, this.mountInfoProvider, definition, definitionBuilder, reindex, this.writerConfig), definition.getIndexName());
        }
        DefaultIndexWriter writer = new DefaultIndexWriter(definition, definitionBuilder, this.directoryFactory, ":data", ":suggest-data", reindex, this.writerConfig);
        return this.wrapWithPipelinedIndexWriter(writer, definition.getIndexName());
    }

    @Override
    public void close() {
        LOG.debug("Closing LuceneIndexWriterFactory");
        if (this.indexWriterPool == null) {
            LOG.debug("Not using an Index writer pool");
        } else {
            this.indexWriterPool.close();
        }
    }

    private LuceneIndexWriter wrapWithPipelinedIndexWriter(LuceneIndexWriter writer, String indexName) {
        return this.indexWriterPool == null ? writer : new PooledLuceneIndexWriter(this.indexWriterPool, writer, indexName);
    }
}

