/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.writer;

import java.io.Closeable;
import java.io.IOException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.pio.Closer;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SuggestHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.IndexWriterUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriterConfig;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultIndexWriter
implements LuceneIndexWriter {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexWriter.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(LuceneIndexWriter.class.getName() + ".perf")));
    private final LuceneIndexDefinition definition;
    private final NodeBuilder definitionBuilder;
    private final DirectoryFactory directoryFactory;
    private final String dirName;
    private final String suggestDirName;
    private final boolean reindex;
    private final LuceneIndexWriterConfig writerConfig;
    private volatile IndexWriter writer;
    private Directory directory;
    private long genAtStart = -1L;
    private boolean indexUpdated = false;

    public DefaultIndexWriter(LuceneIndexDefinition definition, NodeBuilder definitionBuilder, DirectoryFactory directoryFactory, String dirName, String suggestDirName, boolean reindex, LuceneIndexWriterConfig writerConfig) {
        this.definition = definition;
        this.definitionBuilder = definitionBuilder;
        this.directoryFactory = directoryFactory;
        this.dirName = dirName;
        this.suggestDirName = suggestDirName;
        this.reindex = reindex;
        this.writerConfig = writerConfig;
    }

    @Override
    public void updateDocument(String path, Iterable<? extends IndexableField> doc) throws IOException {
        boolean isPropertyRegexMatchingEnabled;
        Iterator<? extends IndexableField> f = doc.iterator();
        String fieldName = f.hasNext() ? f.next().name() : null;
        boolean containsOnlyPath = ":path".equals(fieldName) && !f.hasNext();
        boolean bl = isPropertyRegexMatchingEnabled = this.definition.getPropertyRegex() != null;
        if (this.reindex) {
            if (containsOnlyPath && isPropertyRegexMatchingEnabled) {
                return;
            }
            this.getWriter().addDocument(doc);
        } else if (containsOnlyPath && isPropertyRegexMatchingEnabled) {
            this.getWriter().deleteDocuments(TermFactory.newPathTerm(path));
        } else {
            this.getWriter().updateDocument(TermFactory.newPathTerm(path), doc);
        }
        this.indexUpdated = true;
    }

    @Override
    public void deleteDocuments(String path) throws IOException {
        this.getWriter().deleteDocuments(TermFactory.newPathTerm(path));
        this.getWriter().deleteDocuments((Query)new PrefixQuery(TermFactory.newPathTerm(path + "/")));
    }

    void deleteAll() throws IOException {
        this.getWriter().deleteAll();
        this.indexUpdated = true;
    }

    @Override
    public boolean close(long timestamp) throws IOException {
        if (this.reindex && this.writer == null) {
            this.getWriter();
        }
        Calendar currentTime = Calendar.getInstance();
        currentTime.setTimeInMillis(timestamp);
        boolean updateSuggestions = this.shouldUpdateSuggestions(currentTime);
        if (this.writer == null && updateSuggestions) {
            log.debug("Would update suggester dictionary although no index changes were detected in current cycle");
            this.getWriter();
        }
        if (this.writer != null) {
            if (log.isTraceEnabled()) {
                DefaultIndexWriter.trackIndexSizeInfo(this.writer, this.definition, this.directory);
            }
            long start = PERF_LOGGER.start();
            if (updateSuggestions) {
                this.indexUpdated |= this.updateSuggester(this.writer.getAnalyzer(), currentTime);
                PERF_LOGGER.end(start, -1L, "Completed suggester for directory {}", (Object)this.definition);
            }
            this.writer.close();
            PERF_LOGGER.end(start, -1L, "Closed writer for directory {}", (Object)this.definition);
            if (!this.indexUpdated) {
                long genAtEnd = DefaultIndexWriter.getLatestGeneration(this.directory);
                this.indexUpdated = genAtEnd != this.genAtStart;
            }
            this.directory.close();
            PERF_LOGGER.end(start, -1L, "Closed directory for directory {}", (Object)this.definition);
        }
        return this.indexUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexWriter getWriter() throws IOException {
        IndexWriter localRefWriter = this.writer;
        if (localRefWriter == null) {
            DefaultIndexWriter defaultIndexWriter = this;
            synchronized (defaultIndexWriter) {
                localRefWriter = this.writer;
                if (localRefWriter == null) {
                    long start = PERF_LOGGER.start();
                    this.directory = this.directoryFactory.newInstance(this.definition, this.definitionBuilder, this.dirName, this.reindex);
                    boolean serialScheduler = this.directoryFactory.remoteDirectory();
                    IndexWriterConfig config = IndexWriterUtils.getIndexWriterConfig(this.definition, serialScheduler, this.writerConfig);
                    config.setMergePolicy(this.definition.getMergePolicy());
                    this.writer = localRefWriter = new IndexWriter(this.directory, config);
                    this.genAtStart = DefaultIndexWriter.getLatestGeneration(this.directory);
                    log.debug("Creating writer for index: {}. Config: {}", (Object)this.definition.getIndexPath(), (Object)config);
                    PERF_LOGGER.end(start, -1L, "Created IndexWriter for directory {}", (Object)this.definition);
                }
            }
        }
        return localRefWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSuggester(Analyzer analyzer, Calendar currentTime) throws IOException {
        DefaultIndexWriter defaultIndexWriter = this;
        synchronized (defaultIndexWriter) {
            Closer closer = Closer.create();
            NodeBuilder suggesterStatus = this.definitionBuilder.child(this.suggestDirName);
            DirectoryReader reader = (DirectoryReader)closer.register((Closeable)DirectoryReader.open(this.writer, false));
            Directory suggestDirectory = this.directoryFactory.newInstance(this.definition, this.definitionBuilder, this.suggestDirName, false);
            boolean updated = false;
            try {
                SuggestHelper.updateSuggester(suggestDirectory, analyzer, reader, closer);
                suggesterStatus.setProperty("lastUpdated", (Object)ISO8601.format((Calendar)currentTime), Type.DATE);
                updated = true;
            }
            catch (Throwable e) {
                log.warn("could not update suggester", e);
            }
            finally {
                closer.close();
            }
            return updated;
        }
    }

    private boolean shouldUpdateSuggestions(Calendar currentTime) {
        boolean updateSuggestions = false;
        if (this.definition.isSuggestEnabled()) {
            NodeBuilder suggesterStatus = this.definitionBuilder.child(this.suggestDirName);
            PropertyState suggesterLastUpdatedValue = suggesterStatus.getProperty("lastUpdated");
            if (suggesterLastUpdatedValue != null) {
                Calendar suggesterLastUpdatedTime = ISO8601.parse((String)((String)suggesterLastUpdatedValue.getValue(Type.DATE)));
                int updateFrequency = this.definition.getSuggesterUpdateFrequencyMinutes();
                Calendar nextSuggestUpdateTime = (Calendar)suggesterLastUpdatedTime.clone();
                nextSuggestUpdateTime.add(12, updateFrequency);
                if (currentTime.after(nextSuggestUpdateTime)) {
                    updateSuggestions = this.writer != null || this.isIndexUpdatedAfter(suggesterLastUpdatedTime);
                }
            } else {
                updateSuggestions = true;
            }
        }
        return updateSuggestions;
    }

    private boolean isIndexUpdatedAfter(Calendar calendar) {
        NodeBuilder indexStats = this.definitionBuilder.child(":status");
        PropertyState indexLastUpdatedValue = indexStats.getProperty("lastUpdated");
        if (indexLastUpdatedValue != null) {
            Calendar indexLastUpdatedTime = ISO8601.parse((String)((String)indexLastUpdatedValue.getValue(Type.DATE)));
            return indexLastUpdatedTime.after(calendar);
        }
        return true;
    }

    private static long getLatestGeneration(Directory directory) throws IOException {
        List<IndexCommit> commits;
        if (DirectoryReader.indexExists(directory) && !(commits = DirectoryReader.listCommits(directory)).isEmpty()) {
            return commits.get(commits.size() - 1).getGeneration();
        }
        return -1L;
    }

    private static void trackIndexSizeInfo(@NotNull IndexWriter writer, @NotNull IndexDefinition definition, @NotNull Directory directory) throws IOException {
        Objects.requireNonNull(writer);
        Objects.requireNonNull(definition);
        Objects.requireNonNull(directory);
        int docs = writer.numDocs();
        int ram = writer.numRamDocs();
        log.trace("Writer for directory {} - docs: {}, ramDocs: {}", new Object[]{definition, docs, ram});
        String[] files = directory.listAll();
        long overallSize = 0L;
        StringBuilder sb = new StringBuilder();
        for (String f : files) {
            sb.append(f).append(":");
            if (directory.fileExists(f)) {
                long size = directory.fileLength(f);
                overallSize += size;
                sb.append(size);
            } else {
                sb.append("--");
            }
            sb.append(", ");
        }
        log.trace("Directory overall size: {}, files: {}", (Object)IOUtils.humanReadableByteCount((long)overallSize), (Object)sb);
    }

    public String toString() {
        return "DefaultIndexWriter{index=" + this.definition.getIndexName() + "}";
    }
}

