/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.util.Arrays;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.CompoundWordTokenFilterBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Version;

public class OakWordTokenFilter
extends CompoundWordTokenFilterBase {
    private static final String ALPHANUM_TYPE = StandardTokenizer.TOKEN_TYPES[0];
    private static final char[] SEPARATORS = new char[]{'_', '.'};
    private final char[] separators;
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public OakWordTokenFilter(Version version, TokenStream in, char[] separators) {
        super(version, in, null);
        this.separators = separators;
        Arrays.sort(this.separators);
    }

    public OakWordTokenFilter(Version version, TokenStream in) {
        this(version, in, SEPARATORS);
    }

    @Override
    protected void decompose() {
        if (ALPHANUM_TYPE.equals(this.typeAtt.type())) {
            int len = this.termAtt.length();
            char[] buffer = this.termAtt.buffer();
            int tokenLen = 0;
            boolean foundOne = false;
            for (int i = 0; i < len; ++i) {
                if (Arrays.binarySearch(this.separators, buffer[i]) >= 0) {
                    foundOne = true;
                    if (tokenLen > 0) {
                        CompoundWordTokenFilterBase.CompoundToken ct = new CompoundWordTokenFilterBase.CompoundToken(i - tokenLen, tokenLen);
                        this.tokens.add(ct);
                    }
                    tokenLen = 0;
                    continue;
                }
                ++tokenLen;
            }
            if (foundOne && tokenLen > 0) {
                CompoundWordTokenFilterBase.CompoundToken ct = new CompoundWordTokenFilterBase.CompoundToken(len - tokenLen, tokenLen);
                this.tokens.add(ct);
            }
        }
    }
}

