/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsFormat;
import org.apache.lucene.codecs.compressing.CompressingTermVectorsFormat;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.lucene40.Lucene40LiveDocsFormat;
import org.apache.lucene.codecs.lucene42.Lucene42NormsFormat;
import org.apache.lucene.codecs.lucene46.Lucene46Codec;
import org.apache.lucene.codecs.lucene46.Lucene46FieldInfosFormat;
import org.apache.lucene.codecs.lucene46.Lucene46SegmentInfoFormat;

public class CompressingCodec
extends FilterCodec {
    private static final int CHUNK_SIZE = 1024;
    private static final String SEGMENT_SUFFIX = "ctv";
    private final TermVectorsFormat vectorsFormat = new CompressingTermVectorsFormat("Lucene41", "ctv", CompressionMode.HIGH_COMPRESSION, 1024);
    private final FieldInfosFormat fieldInfosFormat = new Lucene46FieldInfosFormat();
    private final SegmentInfoFormat segmentInfosFormat = new Lucene46SegmentInfoFormat();
    private final LiveDocsFormat liveDocsFormat = new Lucene40LiveDocsFormat();
    private final PostingsFormat defaultFormat = PostingsFormat.forName("Lucene41");
    private final DocValuesFormat defaultDVFormat = DocValuesFormat.forName("Lucene45");
    private final NormsFormat normsFormat = new Lucene42NormsFormat();
    private final StoredFieldsFormat fieldsFormat = new CompressingStoredFieldsFormat("Lucene41", CompressionMode.HIGH_COMPRESSION, 1024);

    public CompressingCodec() {
        super("compressingCodec", new Lucene46Codec());
    }

    @Override
    public PostingsFormat postingsFormat() {
        return this.defaultFormat;
    }

    @Override
    public DocValuesFormat docValuesFormat() {
        return this.defaultDVFormat;
    }

    @Override
    public StoredFieldsFormat storedFieldsFormat() {
        return this.fieldsFormat;
    }

    @Override
    public TermVectorsFormat termVectorsFormat() {
        return this.vectorsFormat;
    }

    @Override
    public FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    @Override
    public SegmentInfoFormat segmentInfoFormat() {
        return this.segmentInfosFormat;
    }

    @Override
    public NormsFormat normsFormat() {
        return this.normsFormat;
    }

    @Override
    public LiveDocsFormat liveDocsFormat() {
        return this.liveDocsFormat;
    }
}

