/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.reader;

import java.io.Closeable;
import java.io.IOException;
import org.apache.jackrabbit.oak.commons.pio.Closer;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReader;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SuggestHelper;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.Directory;
import org.jetbrains.annotations.Nullable;

public class DefaultIndexReader
implements LuceneIndexReader {
    private final Closer closer = Closer.create();
    private final Directory directory;
    private final Directory suggestDirectory;
    private final IndexReader reader;
    private final AnalyzingInfixSuggester lookup;

    public DefaultIndexReader(Directory directory, @Nullable Directory suggestDirectory, Analyzer analyzer) throws IOException {
        this.directory = directory;
        this.closer.register((Closeable)this.directory);
        this.reader = DirectoryReader.open(directory);
        this.closer.register((Closeable)this.reader);
        this.suggestDirectory = suggestDirectory;
        if (suggestDirectory != null) {
            this.lookup = SuggestHelper.getLookup(suggestDirectory, analyzer);
            this.closer.register((Closeable)this.lookup);
        } else {
            this.lookup = null;
        }
    }

    @Override
    public IndexReader getReader() {
        return this.reader;
    }

    @Override
    @Nullable
    public AnalyzingInfixSuggester getLookup() {
        return this.lookup;
    }

    @Override
    @Nullable
    public Directory getSuggestDirectory() {
        return this.suggestDirectory;
    }

    @Override
    public long getIndexSize() throws IOException {
        return DirectoryUtils.dirSize(this.directory);
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

