/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.property;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.internal.graph.Traverser;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.HybridPropertyIndexUtil;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class HybridPropertyIndexInfo {
    private final JsopBuilder json = new JsopBuilder();
    private final NodeState idx;

    public HybridPropertyIndexInfo(NodeState idx) {
        this.idx = idx;
    }

    public String getInfoAsJson() {
        this.json.resetWriter();
        this.json.object();
        NodeState propertyIndexNode = this.idx.getChildNode(":property-index");
        for (ChildNodeEntry cne : propertyIndexNode.getChildNodeEntries()) {
            NodeState propIdxState = cne.getNodeState();
            String propName = cne.getName();
            this.json.key(propName).object();
            if (HybridPropertyIndexUtil.simplePropertyIndex(propIdxState)) {
                this.collectBucketData(propIdxState);
            } else if (HybridPropertyIndexUtil.uniquePropertyIndex(propIdxState)) {
                this.json.key("entryCount").value(propIdxState.getChildNodeCount(Integer.MAX_VALUE));
                this.json.key("unique").value(true);
            }
            this.json.endObject();
        }
        this.json.endObject();
        return JsopBuilder.prettyPrint((String)this.json.toString());
    }

    private void collectBucketData(NodeState propIdxState) {
        String head = propIdxState.getString("head");
        String previous = propIdxState.getString("previous");
        for (ChildNodeEntry cne : propIdxState.getChildNodeEntries()) {
            String bucketName = cne.getName();
            NodeState bucket = cne.getNodeState();
            this.json.key(bucketName).object();
            this.json.key("type");
            if (Objects.equals(head, bucketName)) {
                this.json.value("head");
            } else if (Objects.equals(previous, bucketName)) {
                this.json.value("previous");
            } else {
                this.json.value("garbage");
            }
            this.json.key("keyCount").value(bucket.getChildNodeCount(Integer.MAX_VALUE));
            this.collectCounts(bucket);
            this.json.endObject();
        }
    }

    private void collectCounts(NodeState bucket) {
        Function<NodeState, Iterable> children = root -> IterableUtils.transform((Iterable)root.getChildNodeEntries(), ChildNodeEntry::getNodeState);
        AtomicInteger matches = new AtomicInteger();
        int totalCount = Traverser.preOrderTraversal((Object)bucket, children).transform(st -> {
            if (st.getBoolean("match")) {
                matches.incrementAndGet();
            }
            return st;
        }).size();
        this.json.key("entryCount").value((long)matches.get());
        this.json.key("totalCount").value((long)totalCount);
    }
}

