/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.property;

import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

class BucketSwitcher {
    private final NodeBuilder builder;

    public BucketSwitcher(NodeBuilder builder) {
        this.builder = builder;
    }

    public boolean switchBucket(long lastIndexedTo) {
        String head = this.builder.getString("head");
        if (head == null) {
            return false;
        }
        NodeBuilder headb = this.builder.getChildNode(head);
        long headLastIndexedTo = BucketSwitcher.getOptionalValue(headb, "asyncIndexedToTimeAtSwitch", 0);
        if (headLastIndexedTo > lastIndexedTo) {
            return false;
        }
        if (headLastIndexedTo == lastIndexedTo) {
            return false;
        }
        if (this.asyncIndexedToTimeSameAsPrevious(lastIndexedTo)) {
            return false;
        }
        if (headb.getChildNodeCount(1L) > 0L) {
            String nextHeadName = String.valueOf(Integer.parseInt(head) + 1);
            this.builder.child(nextHeadName);
            this.builder.setProperty("head", (Object)nextHeadName);
            this.builder.setProperty("previous", (Object)head);
            headb.setProperty("asyncIndexedToTimeAtSwitch", (Object)lastIndexedTo);
        } else {
            if (headLastIndexedTo == 0L) {
                headb.setProperty("asyncIndexedToTimeAtSwitch", (Object)lastIndexedTo);
            }
            this.builder.removeProperty("previous");
        }
        return this.builder.isModified();
    }

    public Iterable<String> getOldBuckets() {
        String head = this.builder.getString("head");
        String previous = this.builder.getString("previous");
        return IterableUtils.filter((Iterable)this.builder.getChildNodeNames(), name -> !Objects.equals(name, head) && !Objects.equals(name, previous));
    }

    private boolean asyncIndexedToTimeSameAsPrevious(long lastIndexedTo) {
        String previous = this.builder.getString("previous");
        if (previous != null) {
            long previousAsyncIndexedTo = BucketSwitcher.getOptionalValue(this.builder.getChildNode(previous), "asyncIndexedToTimeAtSwitch", 0);
            return previousAsyncIndexedTo == lastIndexedTo;
        }
        return false;
    }

    private static long getOptionalValue(NodeBuilder nb, String propName, int defaultVal) {
        PropertyState ps = nb.getProperty(propName);
        return ps == null ? (long)defaultVal : (Long)ps.getValue(Type.LONG);
    }
}

