/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.multimap.ArrayListValuedLinkedHashMap;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.NRTDirectoryFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.NRTIndex;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.update.IndexUpdateListener;
import org.apache.jackrabbit.oak.plugins.index.search.update.RefreshOnWritePolicy;
import org.apache.jackrabbit.oak.plugins.index.search.update.TimedRefreshPolicy;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NRTIndexFactory
implements Closeable {
    private static final int MAX_INDEX_COUNT = 3;
    private static final int REFRESH_DELTA_IN_SECS = Integer.getInteger("oak.lucene.refreshDeltaSecs", 1);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ArrayListValuedLinkedHashMap<String, NRTIndex> indexes = new ArrayListValuedLinkedHashMap();
    private final IndexCopier indexCopier;
    private final Clock clock;
    private final long refreshDeltaInSecs;
    private final StatisticsProvider statisticsProvider;
    private NRTDirectoryFactory directoryFactory = DefaultNRTDirFactory.INSTANCE;
    private boolean assertAllResourcesClosed = Boolean.getBoolean("oak.lucene.assertAllResourcesClosed");

    public NRTIndexFactory(IndexCopier indexCopier, StatisticsProvider statisticsProvider) {
        this(indexCopier, Clock.SIMPLE, REFRESH_DELTA_IN_SECS, statisticsProvider);
    }

    public NRTIndexFactory(IndexCopier indexCopier, Clock clock, long refreshDeltaInSecs, StatisticsProvider statisticsProvider) {
        this.indexCopier = Objects.requireNonNull(indexCopier);
        this.clock = clock;
        this.refreshDeltaInSecs = refreshDeltaInSecs;
        this.statisticsProvider = statisticsProvider;
        this.log.info("Refresh delta set to {} secs", (Object)refreshDeltaInSecs);
    }

    @Nullable
    public synchronized NRTIndex createIndex(LuceneIndexDefinition definition) {
        if (!definition.isNRTIndexingEnabled() && !definition.isSyncIndexingEnabled()) {
            return null;
        }
        String indexPath = definition.getIndexPath();
        NRTIndex current = new NRTIndex(definition, this.indexCopier, this.getRefreshPolicy(definition), this.getPrevious(indexPath), this.statisticsProvider, this.directoryFactory, this.assertAllResourcesClosed);
        this.indexes.put((Object)indexPath, (Object)current);
        this.closeLast(indexPath);
        return current;
    }

    @Override
    public void close() throws IOException {
        for (String indexPath : this.indexes.keySet()) {
            List nrtIndexes = this.indexes.get((Object)indexPath);
            for (int i = nrtIndexes.size() - 1; i >= 0; --i) {
                ((NRTIndex)nrtIndexes.get(i)).close();
            }
        }
        this.indexes.clear();
    }

    List<NRTIndex> getIndexes(String path) {
        return this.indexes.get((Object)path);
    }

    public void setDirectoryFactory(NRTDirectoryFactory directoryFactory) {
        this.directoryFactory = directoryFactory;
    }

    public void setAssertAllResourcesClosed(boolean assertAllResourcesClosed) {
        this.assertAllResourcesClosed = assertAllResourcesClosed;
    }

    private void closeLast(String indexPath) {
        List existing = this.indexes.get((Object)indexPath);
        if (existing.size() <= 3) {
            return;
        }
        NRTIndex oldest = (NRTIndex)existing.remove(0);
        ((NRTIndex)existing.get(0)).disconnectPrevious();
        try {
            oldest.close();
        }
        catch (IOException e) {
            this.log.warn("Error occurred while closing index [{}]", (Object)oldest, (Object)e);
        }
    }

    private NRTIndex getPrevious(String indexPath) {
        List existing = this.indexes.get((Object)indexPath);
        if (existing.isEmpty()) {
            return null;
        }
        Validate.checkArgument((existing.size() <= 3 ? 1 : 0) != 0, (String)"Found [%s] more than 3 index", (Object[])new Object[]{existing.size()});
        return (NRTIndex)existing.get(existing.size() - 1);
    }

    private IndexUpdateListener getRefreshPolicy(IndexDefinition definition) {
        if (definition.isSyncIndexingEnabled()) {
            return new RefreshOnWritePolicy();
        }
        return new TimedRefreshPolicy(this.clock, TimeUnit.SECONDS, this.refreshDeltaInSecs);
    }

    private static enum DefaultNRTDirFactory implements NRTDirectoryFactory
    {
        INSTANCE;


        @Override
        public Directory createNRTDir(IndexDefinition definition, File indexDir) throws IOException {
            FSDirectory fsdir = FSDirectory.open(indexDir);
            return new NRTCachingDirectory(fsdir, 1.0, 1.0);
        }
    }
}

