/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import java.util.Objects;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDocInfo;
import org.apache.lucene.index.IndexableField;
import org.jetbrains.annotations.Nullable;

class LuceneDoc
implements LuceneDocInfo {
    final String indexPath;
    final String docPath;
    final Iterable<? extends IndexableField> doc;
    final boolean delete;
    private volatile boolean processed;

    public static LuceneDoc forUpdate(String indexPath, String path, Iterable<? extends IndexableField> doc) {
        return new LuceneDoc(indexPath, path, Objects.requireNonNull(doc), false);
    }

    public static LuceneDoc forDelete(String indexPath, String path) {
        return new LuceneDoc(indexPath, path, null, true);
    }

    private LuceneDoc(String indexPath, String path, @Nullable Iterable<? extends IndexableField> doc, boolean delete) {
        this.docPath = Objects.requireNonNull(path);
        this.indexPath = Objects.requireNonNull(indexPath);
        this.doc = doc;
        this.delete = delete;
    }

    public String toString() {
        return String.format("%s(%s)", this.indexPath, this.docPath);
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void markProcessed() {
        this.processed = true;
    }

    @Override
    public String getIndexPath() {
        return this.indexPath;
    }

    @Override
    public String getDocPath() {
        return this.docPath;
    }
}

