/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.ExternalIndexObserver;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexingQueue;
import org.apache.jackrabbit.oak.plugins.observation.Filter;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalObserverBuilder {
    private static final Logger log = LoggerFactory.getLogger(ExternalIndexObserver.class);
    private final IndexingQueue indexingQueue;
    private final IndexTracker indexTracker;
    private final StatisticsProvider statisticsProvider;
    private final Executor executor;
    private final int queueSize;
    private BackgroundObserver backgroundObserver;
    private FilteringObserver filteringObserver;

    public ExternalObserverBuilder(IndexingQueue indexingQueue, IndexTracker indexTracker, StatisticsProvider statisticsProvider, Executor executor, int queueSize) {
        this.indexingQueue = Objects.requireNonNull(indexingQueue);
        this.indexTracker = Objects.requireNonNull(indexTracker);
        this.statisticsProvider = Objects.requireNonNull(statisticsProvider);
        this.executor = Objects.requireNonNull(executor);
        this.queueSize = queueSize;
    }

    public Observer build() {
        if (this.filteringObserver != null) {
            return this.filteringObserver;
        }
        ExternalIndexObserver externalObserver = new ExternalIndexObserver(this.indexingQueue, this.indexTracker, this.statisticsProvider);
        this.backgroundObserver = new WarningObserver(externalObserver, this.executor, this.queueSize);
        this.filteringObserver = new FilteringObserver((Observer)this.backgroundObserver, externalObserver);
        return this.filteringObserver;
    }

    public BackgroundObserver getBackgroundObserver() {
        return this.backgroundObserver;
    }

    private static class FilteringObserver
    implements Observer {
        private final Observer delegate;
        private final Filter filter;

        private FilteringObserver(Observer delegate, Filter filter) {
            this.delegate = delegate;
            this.filter = filter;
        }

        public void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
            if (!this.filter.excludes(root, info)) {
                this.delegate.contentChanged(root, info);
            }
        }
    }

    private static class WarningObserver
    extends BackgroundObserver {
        private final int queueLength;

        public WarningObserver(@NotNull Observer observer, @NotNull Executor executor, int queueLength) {
            super(observer, executor, queueLength);
            this.queueLength = queueLength;
        }

        protected void added(int queueSize) {
            if (queueSize >= this.queueLength) {
                log.warn("External observer queue is full");
            }
        }
    }
}

