/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.IOException;
import java.util.Iterator;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.BlobFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakIndexFile;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.WeakIdentityMap;

class OakIndexInput
extends IndexInput {
    final OakIndexFile file;
    private boolean isClone = false;
    private final WeakIdentityMap<OakIndexInput, Boolean> clones;
    private final String dirDetails;

    public OakIndexInput(String name, NodeBuilder file, String dirDetails, BlobFactory blobFactory) {
        super(name);
        this.dirDetails = dirDetails;
        this.file = OakIndexFile.getOakIndexFile(name, file, dirDetails, blobFactory);
        this.clones = WeakIdentityMap.newConcurrentHashMap();
    }

    private OakIndexInput(OakIndexInput that) {
        super(that.toString());
        this.file = that.file.clone();
        this.clones = null;
        this.dirDetails = that.dirDetails;
    }

    @Override
    public OakIndexInput clone() {
        OakIndexInput clonedIndexInput = new OakIndexInput(this);
        clonedIndexInput.isClone = true;
        if (this.clones != null) {
            this.clones.put(clonedIndexInput, Boolean.TRUE);
        }
        return clonedIndexInput;
    }

    @Override
    public void readBytes(byte[] b, int o, int n) throws IOException {
        this.checkNotClosed();
        this.file.readBytes(b, o, n);
    }

    @Override
    public byte readByte() throws IOException {
        this.checkNotClosed();
        byte[] b = new byte[1];
        this.readBytes(b, 0, 1);
        return b[0];
    }

    @Override
    public void seek(long pos) throws IOException {
        this.checkNotClosed();
        this.file.seek(pos);
    }

    @Override
    public long length() {
        this.checkNotClosed();
        return this.file.length();
    }

    @Override
    public long getFilePointer() {
        this.checkNotClosed();
        return this.file.position();
    }

    @Override
    public void close() {
        this.file.close();
        if (this.clones != null) {
            Iterator<OakIndexInput> it = this.clones.keyIterator();
            while (it.hasNext()) {
                OakIndexInput clone = it.next();
                assert (clone.isClone);
                clone.close();
            }
        }
    }

    private void checkNotClosed() {
        if (this.file.isClosed()) {
            throw new AlreadyClosedException("Already closed: [" + this.dirDetails + "] " + String.valueOf(this));
        }
    }
}

