/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.commons.pio.Closer;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexImporterProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LocalIndexDir;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakDirectory;
import org.apache.jackrabbit.oak.plugins.index.search.ReindexOperations;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;

public class LuceneIndexImporter
implements IndexImporterProvider {
    private GarbageCollectableBlobStore blobStore;

    public LuceneIndexImporter() {
    }

    public LuceneIndexImporter(GarbageCollectableBlobStore blobStore) {
        this.blobStore = blobStore;
    }

    public void importIndex(NodeState root, NodeBuilder definitionBuilder, File indexDir) throws IOException {
        LocalIndexDir localIndex = new LocalIndexDir(indexDir);
        definitionBuilder.getChildNode(":status").remove();
        ReindexOperations reindexOps = new ReindexOperations(root, definitionBuilder, localIndex.getJcrPath(), new LuceneIndexDefinition.Builder());
        LuceneIndexDefinition definition = (LuceneIndexDefinition)reindexOps.apply(true);
        for (File dir : localIndex.dir.listFiles(File::isDirectory)) {
            String jcrName = localIndex.indexMeta.getJcrNameFromFSName(dir.getName());
            if (jcrName == null) continue;
            this.copyDirectory(definition, definitionBuilder, jcrName, dir);
        }
    }

    public String getType() {
        return "lucene";
    }

    public void setBlobStore(GarbageCollectableBlobStore blobStore) {
        this.blobStore = blobStore;
    }

    private void copyDirectory(LuceneIndexDefinition definition, NodeBuilder definitionBuilder, String jcrName, File dir) throws IOException {
        try (Closer closer = Closer.create();){
            FSDirectory sourceDir = FSDirectory.open(dir);
            closer.register((Closeable)sourceDir);
            definitionBuilder.getChildNode(jcrName).remove();
            OakDirectory targetDir = new OakDirectory(definitionBuilder, jcrName, definition, false, this.blobStore);
            closer.register((Closeable)targetDir);
            for (String file : ((Directory)sourceDir).listAll()) {
                sourceDir.copy(targetDir, file, file, IOContext.DEFAULT);
            }
        }
    }
}

