/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryUtils;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSanityChecker {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Directory local;
    private final Directory remote;
    private final String indexPath;
    private int localFileCount;
    private int remoteFileCount;
    private long localDirSize;
    private long remoteDirSize;

    public IndexSanityChecker(String indexPath, Directory local, Directory remote) {
        this.local = local;
        this.remote = remote;
        this.indexPath = indexPath;
    }

    public boolean check(IndexSanityStatistics stats) throws IOException {
        boolean allFine = true;
        long start = System.currentTimeMillis();
        if (this.isThereASizeMismatch()) {
            IndexSanityChecker.deleteAllFiles(this.local);
            allFine = false;
        } else {
            for (String fileName : this.local.listAll()) {
                if (this.remote.fileExists(fileName)) continue;
                this.local.deleteFile(fileName);
            }
        }
        stats.addDuration(System.currentTimeMillis() - start);
        stats.addIndexSize(this.localDirSize);
        if (allFine) {
            this.log.info("Local index directory content found to be valid for index [{}]. Stats Local: {} files ({}), Remote: {} files ({}), accumulated statistics on checking index sanity: {}", new Object[]{this.indexPath, this.localFileCount, IOUtils.humanReadableByteCount((long)this.localDirSize), this.remoteFileCount, IOUtils.humanReadableByteCount((long)this.remoteDirSize), stats.toString()});
        } else {
            this.log.warn("Local index directory content were not found to be in sync with remote for index [{}]. Local directory content has been purged and would be synced again from remote.", (Object)this.indexPath);
        }
        return allFine;
    }

    private boolean isThereASizeMismatch() throws IOException {
        for (String fileName : this.remote.listAll()) {
            long remoteLength;
            long localLength;
            block5: {
                localLength = DirectoryUtils.getFileLength(this.local, fileName);
                remoteLength = 0L;
                try {
                    remoteLength = this.remote.fileLength(fileName);
                }
                catch (FileNotFoundException ignore) {
                    if (localLength != -1L) break block5;
                    this.log.info("{} is not present on remote as well as local", (Object)fileName);
                    continue;
                }
            }
            if (localLength > 0L && localLength != remoteLength) {
                this.log.warn("[{}] Found local copy for {} in {} but size of local {} differs from remote {}. ", new Object[]{this.indexPath, fileName, this.local, localLength, remoteLength});
                return true;
            }
            if (localLength > 0L) {
                this.localDirSize += localLength;
                ++this.localFileCount;
            }
            this.remoteDirSize += remoteLength;
            ++this.remoteFileCount;
        }
        return false;
    }

    private static void deleteAllFiles(Directory dir) throws IOException {
        for (String fileName : dir.listAll()) {
            dir.deleteFile(fileName);
        }
    }

    public static class IndexSanityStatistics {
        long totalDurationInMs;
        long totalIndexSize;

        public void addDuration(long milis) {
            this.totalDurationInMs += milis;
        }

        public long getAccumulatedDuration() {
            return this.totalDurationInMs;
        }

        public void addIndexSize(long bytes) {
            this.totalIndexSize += bytes;
        }

        public long getAccumulatedIndexSize() {
            return this.totalIndexSize;
        }

        public String toString() {
            return String.format("[duration: %d ms, checked index size: %d bytes (%s)]", this.totalDurationInMs, this.totalIndexSize, IOUtils.humanReadableByteCount((long)this.totalIndexSize));
        }
    }
}

