/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.spi.blob.BlobOptions;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public interface BlobFactory {
    public static final Boolean ENABLE_ASYNC_DS = Boolean.getBoolean("oak.lucene.ds.async");

    public Blob createBlob(InputStream var1) throws IOException;

    public static BlobFactory getNodeBuilderBlobFactory(NodeBuilder builder) {
        return arg_0 -> ((NodeBuilder)builder).createBlob(arg_0);
    }

    public static BlobFactory getBlobStoreBlobFactory(BlobStore store) {
        return in -> {
            String blobId = ENABLE_ASYNC_DS == false ? store.writeBlob(in, new BlobOptions().setUpload(BlobOptions.UploadType.SYNCHRONOUS)) : store.writeBlob(in);
            return new BlobStoreBlob(store, blobId);
        };
    }
}

