/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.commons.FileIOUtils;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.collections.ListUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.blob.BlobTrackingStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobTracker;
import org.apache.jackrabbit.oak.plugins.index.IndexCommitCallback;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveDeletedBlobCollectorFactory {
    public static ActiveDeletedBlobCollector NOOP = new ActiveDeletedBlobCollector(){
        private volatile boolean activeDeletionUnsafe = false;

        @Override
        public BlobDeletionCallback getBlobDeletionCallback() {
            return BlobDeletionCallback.NOOP;
        }

        @Override
        public void purgeBlobsDeleted(long before, GarbageCollectableBlobStore blobStore) {
        }

        @Override
        public void cancelBlobCollection() {
        }

        @Override
        public void flagActiveDeletionUnsafe(boolean toFlag) {
            this.activeDeletionUnsafe = toFlag;
        }

        @Override
        public boolean isActiveDeletionUnsafe() {
            return this.activeDeletionUnsafe;
        }
    };

    public static ActiveDeletedBlobCollector newInstance(@NotNull File rootDirectory, ExecutorService executorService) {
        try {
            FileUtils.forceMkdir((File)rootDirectory);
        }
        catch (IOException ioe) {
            ActiveDeletedBlobCollectorImpl.LOG.warn("Disabling active blob collector as we couldn't not create folder: {}", (Object)rootDirectory, (Object)ioe);
            return NOOP;
        }
        if (!(rootDirectory.canRead() && rootDirectory.canWrite() && rootDirectory.canExecute())) {
            ActiveDeletedBlobCollectorImpl.LOG.warn("Insufficient access in directory - {}. Disabling active blob collector", (Object)rootDirectory);
            return NOOP;
        }
        return new ActiveDeletedBlobCollectorImpl(rootDirectory, executorService);
    }

    static class ActiveDeletedBlobCollectorImpl
    implements ActiveDeletedBlobCollector {
        private static final PerfLogger PERF_LOG = new PerfLogger(LoggerFactory.getLogger((String)(ActiveDeletedBlobCollectorImpl.class.getName() + ".perf")));
        private static final Logger LOG = LoggerFactory.getLogger((String)ActiveDeletedBlobCollectorImpl.class.getName());
        private final Clock clock;
        private final File rootDirectory;
        private final ExecutorService executorService;
        private volatile boolean cancelled;
        private volatile boolean activeDeletionUnsafe = false;
        private static final String BLOB_FILE_PATTERN_PREFIX = "blobs-";
        private static final String BLOB_FILE_PATTERN_SUFFIX = ".txt";
        private static final String BLOB_FILE_PATTERN = "blobs-%s.txt";
        private static final IOFileFilter blobFileNameFilter = new RegexFileFilter("blobs-.*\\.txt");
        private final BlockingQueue<BlobIdInfoStruct> deletedBlobs;
        private final DeletedBlobsFileWriter deletedBlobsFileWriter;

        ActiveDeletedBlobCollectorImpl(@NotNull File rootDirectory, @NotNull ExecutorService executorService) {
            this(Clock.SIMPLE, rootDirectory, executorService);
        }

        ActiveDeletedBlobCollectorImpl(Clock clock, @NotNull File rootDirectory, @NotNull ExecutorService executorService) {
            this.clock = clock;
            this.rootDirectory = rootDirectory;
            this.executorService = executorService;
            this.deletedBlobs = new LinkedBlockingQueue<BlobIdInfoStruct>(100000);
            this.deletedBlobsFileWriter = new DeletedBlobsFileWriter();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void purgeBlobsDeleted(long before, @NotNull GarbageCollectableBlobStore blobStore) {
            long lastCheckedBlobTimestamp;
            this.cancelled = false;
            long start = this.clock.getTime();
            LOG.info("Starting purge of blobs deleted before {}", (Object)before);
            long numBlobsDeleted = 0L;
            long numChunksDeleted = 0L;
            File idTempDeleteFile = null;
            BufferedWriter idTempDeleteWriter = null;
            boolean blobIdsTracked = blobStore instanceof BlobTrackingStore;
            if (blobIdsTracked) {
                try {
                    idTempDeleteFile = File.createTempFile("idTempDelete", null, this.rootDirectory);
                    idTempDeleteWriter = new BufferedWriter(new FileWriter(idTempDeleteFile, StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    LOG.warn("Unable to open a writer to a temp file, will ignore tracker sync");
                    blobIdsTracked = false;
                }
            }
            long lastDeletedBlobTimestamp = lastCheckedBlobTimestamp = this.readLastCheckedBlobTimestamp();
            String currInUseFileName = this.deletedBlobsFileWriter.inUseFileName;
            this.deletedBlobsFileWriter.releaseInUseFile();
            for (File deletedBlobListFile : FileUtils.listFiles((File)this.rootDirectory, (IOFileFilter)blobFileNameFilter, null)) {
                long timestamp;
                if (this.cancelled) break;
                if (deletedBlobListFile.getName().equals(this.deletedBlobsFileWriter.inUseFileName)) continue;
                LOG.debug("Purging blobs from {}", (Object)deletedBlobListFile);
                try {
                    timestamp = ActiveDeletedBlobCollectorImpl.getTimestampFromBlobFileName(deletedBlobListFile.getName());
                }
                catch (IllegalArgumentException iae) {
                    LOG.warn("Couldn't extract timestamp from filename - {}", (Object)deletedBlobListFile, (Object)iae);
                    continue;
                }
                if (timestamp < before) {
                    LineIterator blobLineIter = null;
                    try {
                        blobLineIter = FileUtils.lineIterator((File)deletedBlobListFile);
                        while (blobLineIter.hasNext()) {
                            if (this.cancelled) {
                                break;
                            }
                            String deletedBlobLine = blobLineIter.next();
                            String[] parsedDeletedBlobIdLine = deletedBlobLine.split("\\|", 3);
                            if (parsedDeletedBlobIdLine.length != 3) {
                                LOG.warn("Unparseable line ({}) in file {}. It won't be retried.", (Object)parsedDeletedBlobIdLine, (Object)deletedBlobListFile);
                                continue;
                            }
                            String deletedBlobId = parsedDeletedBlobIdLine[0];
                            try {
                                long blobDeletionTimestamp = Long.parseLong(parsedDeletedBlobIdLine[1]);
                                if (blobDeletionTimestamp < lastCheckedBlobTimestamp) continue;
                                if (blobDeletionTimestamp >= before) {
                                    break;
                                }
                                lastDeletedBlobTimestamp = Math.max(lastDeletedBlobTimestamp, blobDeletionTimestamp);
                                List chunkIds = ListUtils.toList((Iterator)blobStore.resolveChunks(deletedBlobId));
                                if (chunkIds.size() <= 0) continue;
                                long deleted = blobStore.countDeleteChunks(chunkIds, 0L);
                                if (deleted < 1L) {
                                    LOG.warn("Blob {} in file {} not deleted", (Object)deletedBlobId, (Object)deletedBlobListFile);
                                    continue;
                                }
                                ++numBlobsDeleted;
                                numChunksDeleted += deleted;
                                if (!blobIdsTracked) continue;
                                for (String id : chunkIds) {
                                    FileIOUtils.writeAsLine((BufferedWriter)idTempDeleteWriter, (String)id, (boolean)true);
                                }
                            }
                            catch (NumberFormatException nfe) {
                                LOG.warn("Couldn't parse blobTimestamp({}). deletedBlobLine - {}; file - {}", new Object[]{parsedDeletedBlobIdLine[1], deletedBlobLine, deletedBlobListFile.getName(), nfe});
                            }
                            catch (DataStoreException dse) {
                                LOG.debug("Exception occurred while attempting to delete blob {}", (Object)deletedBlobId, (Object)dse);
                            }
                            catch (Exception e) {
                                LOG.warn("Exception occurred while attempting to delete blob {}", (Object)deletedBlobId, (Object)e);
                            }
                        }
                    }
                    catch (IOException ioe) {
                        LOG.warn("Couldn't read deleted blob list file - {}", (Object)deletedBlobListFile, (Object)ioe);
                    }
                    finally {
                        LineIterator.closeQuietly((LineIterator)blobLineIter);
                    }
                    if (deletedBlobListFile.getName().equals(currInUseFileName)) continue;
                    if (!deletedBlobListFile.delete()) {
                        LOG.warn("File {} couldn't be deleted while all blobs listed in it have been purged", (Object)deletedBlobListFile);
                        continue;
                    }
                    LOG.debug("File {} deleted", (Object)deletedBlobListFile);
                    continue;
                }
                LOG.debug("Skipping {} as its timestamp is newer than {}", (Object)deletedBlobListFile.getName(), (Object)before);
            }
            long startBlobTrackerSyncTime = this.clock.getTime();
            try {
                BlobTracker tracker;
                try {
                    IOUtils.close((Closeable)idTempDeleteWriter);
                }
                catch (IOException ex) {
                    LOG.warn("IOException thrown while closing idTempDeleteWriter", (Throwable)ex);
                }
                if (blobIdsTracked && numBlobsDeleted > 0L && (tracker = ((BlobTrackingStore)blobStore).getTracker()) != null) {
                    tracker.remove(idTempDeleteFile, BlobTracker.Options.ACTIVE_DELETION);
                }
            }
            catch (Exception e) {
                LOG.warn("Error refreshing tracked blob ids", (Throwable)e);
            }
            long endBlobTrackerSyncTime = this.clock.getTime();
            LOG.info("Synchronizing changes with blob tracker took {} ms", (Object)(endBlobTrackerSyncTime - startBlobTrackerSyncTime));
            if (this.cancelled) {
                LOG.info("Deletion run cancelled by user");
            }
            long end = this.clock.getTime();
            LOG.info("Deleted {} blobs contained in {} chunks in {} ms", new Object[]{numBlobsDeleted, numChunksDeleted, end - start});
            this.writeOutLastCheckedBlobTimestamp(lastDeletedBlobTimestamp);
        }

        @Override
        public void cancelBlobCollection() {
            this.cancelled = true;
        }

        @Override
        public void flagActiveDeletionUnsafe(boolean toFlag) {
            this.activeDeletionUnsafe = toFlag;
        }

        @Override
        public boolean isActiveDeletionUnsafe() {
            return this.activeDeletionUnsafe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long readLastCheckedBlobTimestamp() {
            Properties p;
            File blobCollectorInfoFile = new File(this.rootDirectory, "collection-info.txt");
            if (!blobCollectorInfoFile.exists()) {
                LOG.debug("Couldn't read last checked blob timestamp (file not found). Would do a bit more scan");
                return -1L;
            }
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(blobCollectorInfoFile));
                p = new Properties();
                p.load(is);
            }
            catch (IOException e) {
                long l;
                try {
                    LOG.warn("Couldn't read last checked blob timestamp from {} ... would do a bit more scan", (Object)blobCollectorInfoFile, (Object)e);
                    l = -1L;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                return l;
            }
            IOUtils.closeQuietly((InputStream)is);
            String resString = p.getProperty("last-checked-blob-timestamp");
            if (resString == null) {
                LOG.warn("Couldn't fine last checked blob timestamp property in collection-info.txt");
                return -1L;
            }
            try {
                return Long.parseLong(resString);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Couldn't read last checked blob timestamp '{}' as long", (Object)resString, (Object)nfe);
                return -1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeOutLastCheckedBlobTimestamp(long timestamp) {
            Properties p = new Properties();
            p.setProperty("last-checked-blob-timestamp", String.valueOf(timestamp));
            File blobCollectorInfoFile = new File(this.rootDirectory, "collection-info.txt");
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(blobCollectorInfoFile));
                p.store(os, "Last checked blob timestamp");
            }
            catch (IOException e) {
                try {
                    LOG.warn("Couldn't write out last checked blob timestamp({})", (Object)timestamp, (Object)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)os);
            }
            IOUtils.closeQuietly((OutputStream)os);
        }

        @Override
        public BlobDeletionCallback getBlobDeletionCallback() throws IllegalStateException {
            return new DeletedBlobCollector();
        }

        static long getTimestampFromBlobFileName(String filename) throws IllegalArgumentException {
            Validate.checkArgument((boolean)filename.startsWith(BLOB_FILE_PATTERN_PREFIX), (String)"Filename(%s) must start with %s", (Object[])new Object[]{filename, BLOB_FILE_PATTERN_PREFIX});
            Validate.checkArgument((boolean)filename.endsWith(BLOB_FILE_PATTERN_SUFFIX), (String)"Filename(%s) must end with %s", (Object[])new Object[]{filename, BLOB_FILE_PATTERN_SUFFIX});
            String timestampStr = filename.substring(BLOB_FILE_PATTERN_PREFIX.length(), filename.length() - BLOB_FILE_PATTERN_SUFFIX.length());
            return Long.parseLong(timestampStr);
        }

        private void addDeletedBlobs(Collection<BlobIdInfoStruct> deletedBlobs) {
            int addedForFlush = 0;
            for (BlobIdInfoStruct info : deletedBlobs) {
                try {
                    if (!this.deletedBlobs.offer(info, 1L, TimeUnit.SECONDS)) {
                        LOG.warn("Timed out while offer-ing {} into queue.", (Object)info);
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    ++addedForFlush;
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while adding " + String.valueOf(info), (Throwable)e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added {} (out of {} tried) to be flushed. QSize: {}", new Object[]{addedForFlush, deletedBlobs.size(), this.deletedBlobs.size()});
            }
            this.deletedBlobsFileWriter.scheduleFileFlushIfNeeded();
        }

        private class BlobIdInfoStruct {
            final String blobId;
            final Iterable<String> ids;

            BlobIdInfoStruct(String blobId, Iterable<String> ids) {
                this.blobId = blobId;
                this.ids = ids;
            }

            public String toString() {
                return String.format("%s|%s|%s", this.blobId, ActiveDeletedBlobCollectorImpl.this.clock.getTime(), String.join((CharSequence)"|", this.ids));
            }
        }

        private class DeletedBlobCollector
        implements BlobDeletionCallback {
            List<BlobIdInfoStruct> deletedBlobs = new ArrayList<BlobIdInfoStruct>();

            private DeletedBlobCollector() {
            }

            @Override
            public void deleted(String blobId, Iterable<String> ids) {
                this.deletedBlobs.add(new BlobIdInfoStruct(blobId, ids));
            }

            public void commitProgress(IndexCommitCallback.IndexProgress indexProgress) {
                if (indexProgress != IndexCommitCallback.IndexProgress.COMMIT_SUCCEDED && indexProgress != IndexCommitCallback.IndexProgress.COMMIT_FAILED) {
                    LOG.debug("We only care for commit success/failure");
                    return;
                }
                if (indexProgress == IndexCommitCallback.IndexProgress.COMMIT_SUCCEDED) {
                    ActiveDeletedBlobCollectorImpl.this.addDeletedBlobs(this.deletedBlobs);
                }
                this.deletedBlobs.clear();
            }

            @Override
            public boolean isMarkingForActiveDeletionUnsafe() {
                return ActiveDeletedBlobCollectorImpl.this.activeDeletionUnsafe;
            }
        }

        private class DeletedBlobsFileWriter
        implements Runnable {
            private final AtomicBoolean fileFlushScheduled = new AtomicBoolean(false);
            private volatile String inUseFileName = null;

            private DeletedBlobsFileWriter() {
            }

            private synchronized void flushDeletedBlobs() {
                LinkedList localDeletedBlobs = new LinkedList();
                ActiveDeletedBlobCollectorImpl.this.deletedBlobs.drainTo(localDeletedBlobs);
                if (localDeletedBlobs.size() > 0) {
                    File outFile = new File(ActiveDeletedBlobCollectorImpl.this.rootDirectory, this.getBlobFileName());
                    try {
                        long start = PERF_LOG.start();
                        FileUtils.writeLines((File)outFile, localDeletedBlobs, (boolean)true);
                        PERF_LOG.end(start, 1L, "Flushing deleted blobs", new Object[0]);
                    }
                    catch (IOException e) {
                        LOG.error("Couldn't write out to {}", (Object)outFile, (Object)e);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Flushed {} blobs to {}", (Object)localDeletedBlobs.size(), (Object)outFile.getName());
                    }
                }
            }

            private void scheduleFileFlushIfNeeded() {
                if (this.fileFlushScheduled.compareAndSet(false, true)) {
                    ActiveDeletedBlobCollectorImpl.this.executorService.submit(this);
                }
            }

            private synchronized void releaseInUseFile() {
                this.inUseFileName = null;
            }

            @Override
            public void run() {
                this.flushDeletedBlobs();
                this.fileFlushScheduled.set(false);
            }

            private String getBlobFileName() {
                if (this.inUseFileName == null) {
                    this.inUseFileName = String.format(ActiveDeletedBlobCollectorImpl.BLOB_FILE_PATTERN, ActiveDeletedBlobCollectorImpl.this.clock.getTime());
                }
                return this.inUseFileName;
            }
        }
    }

    public static interface BlobDeletionCallback
    extends IndexCommitCallback {
        public static final BlobDeletionCallback NOOP = new BlobDeletionCallback(){

            @Override
            public void deleted(String blobId, Iterable<String> ids) {
            }

            public void commitProgress(IndexCommitCallback.IndexProgress indexProgress) {
            }

            @Override
            public boolean isMarkingForActiveDeletionUnsafe() {
                return ActiveDeletedBlobCollectorFactory.NOOP.isActiveDeletionUnsafe();
            }
        };

        public void deleted(String var1, Iterable<String> var2);

        public boolean isMarkingForActiveDeletionUnsafe();
    }

    public static interface ActiveDeletedBlobCollector {
        public BlobDeletionCallback getBlobDeletionCallback();

        public void purgeBlobsDeleted(long var1, GarbageCollectableBlobStore var3);

        public void cancelBlobCollection();

        public void flagActiveDeletionUnsafe(boolean var1);

        public boolean isActiveDeletionUnsafe();
    }
}

