/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import org.apache.lucene.index.Term;

public final class TermFactory {
    private TermFactory() {
    }

    public static Term newPathTerm(String path) {
        return new Term(":path", TermFactory.preparePath(path));
    }

    public static Term newFulltextTerm(String ft, String field) {
        if (field == null || "*".equals(field)) {
            return TermFactory.newFulltextTerm(ft);
        }
        return new Term(field, ft);
    }

    public static Term newAncestorTerm(String path) {
        return new Term(":ancestors", TermFactory.preparePath(path));
    }

    public static Term newFulltextTerm(String ft) {
        return new Term(":fulltext", ft);
    }

    private static String preparePath(String path) {
        if (!"/".equals(path) && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }
}

