/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.util.Collection;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.search.IndexLookup;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LuceneIndexLookupUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneIndexLookupUtil.class);
    static final Predicate<NodeState> LUCENE_INDEX_DEFINITION_PREDICATE = state -> "lucene".equals(state.getString("type"));

    private LuceneIndexLookupUtil() {
    }

    public static String getOldFullTextIndexPath(NodeState root, Filter filter, IndexTracker tracker) {
        Collection<String> indexPaths = LuceneIndexLookupUtil.getLuceneIndexLookup(root).collectIndexNodePaths(filter, false);
        for (String path : indexPaths) {
            LuceneIndexDefinition indexDefinition;
            NodeState node = NodeStateUtils.getNode((NodeState)root, (String)path);
            if (IndexDefinition.determineIndexFormatVersion(node) != IndexFormatVersion.V1) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Old V1 lucene index found at {}", (Object)path);
            }
            if ((indexDefinition = tracker.getIndexDefinition(path)) == null || !indexDefinition.isFullTextEnabled() || indexDefinition.getVersion() != IndexFormatVersion.V1) continue;
            return path;
        }
        return null;
    }

    public static IndexLookup getLuceneIndexLookup(NodeState root) {
        return new IndexLookup(root, LUCENE_INDEX_DEFINITION_PREDICATE);
    }
}

