/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexingContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneDocumentMaker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetsConfigProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.search.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextIndexWriterFactory;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.lucene.facet.FacetsConfig;
import org.jetbrains.annotations.Nullable;

public class LuceneIndexEditorContext
extends FulltextIndexEditorContext
implements FacetsConfigProvider {
    private FacetsConfig facetsConfig;
    private final IndexAugmentorFactory augmentorFactory;

    LuceneIndexEditorContext(NodeState root, NodeBuilder definition, @Nullable IndexDefinition indexDefinition, IndexUpdateCallback updateCallback, FulltextIndexWriterFactory indexWriterFactory, ExtractedTextCache extractedTextCache, IndexAugmentorFactory augmentorFactory, IndexingContext indexingContext, boolean asyncIndexing) {
        super(root, definition, indexDefinition, updateCallback, indexWriterFactory, extractedTextCache, indexingContext, asyncIndexing);
        this.augmentorFactory = augmentorFactory;
    }

    @Override
    public IndexDefinition.Builder newDefinitionBuilder() {
        return new LuceneIndexDefinition.Builder();
    }

    public LuceneDocumentMaker newDocumentMaker(IndexDefinition.IndexingRule rule, String path) {
        LuceneIndexEditorContext facetsConfigProvider = this.isAsyncIndexing() ? this : null;
        return new LuceneDocumentMaker(this.getTextExtractor(), facetsConfigProvider, this.augmentorFactory, this.definition, rule, path);
    }

    public LuceneIndexWriter getWriter() {
        return (LuceneIndexWriter)super.getWriter();
    }

    @Override
    public FacetsConfig getFacetsConfig() {
        if (this.facetsConfig == null) {
            this.facetsConfig = FacetHelper.getFacetsConfig(this.definitionBuilder);
        }
        return this.facetsConfig;
    }

    public static void setClock(Clock c) {
        FulltextIndexEditorContext.setClock(c);
    }
}

