/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.MapUtils;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexNodeManager;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.NRTIndexFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.DefaultIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.plugins.index.search.BadIndexTracker;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.SubtreeEditor;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexTracker {
    private static final long AUTO_REFRESH_MILLIS = Long.getLong("oak.indexTracker.autoRefresh", 3153600000000L);
    private static final Logger log = LoggerFactory.getLogger(IndexTracker.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(IndexTracker.class.getName() + ".perf")));
    private final LuceneIndexReaderFactory readerFactory;
    private final NRTIndexFactory nrtFactory;
    private final BadIndexTracker badIndexTracker = new BadIndexTracker();
    private NodeState root = EmptyNodeState.EMPTY_NODE;
    private AsyncIndexInfoService asyncIndexInfoService;
    private volatile Map<String, LuceneIndexNodeManager> indices = Collections.emptyMap();
    private volatile boolean refresh;
    private volatile long nextAutoRefresh = System.currentTimeMillis() + AUTO_REFRESH_MILLIS;

    public IndexTracker() {
        this((IndexCopier)null);
    }

    public IndexTracker(IndexCopier cloner) {
        this(new DefaultIndexReaderFactory(Mounts.defaultMountInfoProvider(), cloner));
    }

    public IndexTracker(LuceneIndexReaderFactory readerFactory) {
        this(readerFactory, null);
    }

    public IndexTracker(LuceneIndexReaderFactory readerFactory, @Nullable NRTIndexFactory nrtFactory) {
        this.readerFactory = readerFactory;
        this.nrtFactory = nrtFactory;
    }

    public MountInfoProvider getMountInfoProvider() {
        return this.readerFactory.getMountInfoProvider();
    }

    public synchronized void close() {
        Map<String, LuceneIndexNodeManager> indices = this.indices;
        this.indices = Collections.emptyMap();
        for (Map.Entry<String, LuceneIndexNodeManager> entry : indices.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                log.error("Failed to close the Lucene index at {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }

    public synchronized void update(NodeState root) {
        if (this.refresh) {
            this.root = root;
            this.close();
            this.refresh = false;
            log.info("Refreshed the opened indexes");
        } else {
            this.diffAndUpdate(root);
            long now = System.currentTimeMillis();
            if (!this.refresh && now > this.nextAutoRefresh) {
                this.refresh = true;
                this.nextAutoRefresh = now + AUTO_REFRESH_MILLIS;
            }
        }
    }

    public void setAsyncIndexInfoService(AsyncIndexInfoService asyncIndexInfoService) {
        this.asyncIndexInfoService = asyncIndexInfoService;
    }

    public AsyncIndexInfoService getAsyncIndexInfoService() {
        return this.asyncIndexInfoService;
    }

    private synchronized void diffAndUpdate(final NodeState root) {
        if (this.asyncIndexInfoService != null && !this.asyncIndexInfoService.hasIndexerUpdatedForAnyLane(this.root, root)) {
            log.trace("No changed detected in async indexer state. Skipping further diff");
            this.root = root;
            return;
        }
        Map<String, LuceneIndexNodeManager> original = this.indices;
        final HashMap updates = new HashMap();
        HashSet<String> indexPaths = new HashSet<String>();
        indexPaths.addAll(original.keySet());
        indexPaths.addAll(this.badIndexTracker.getIndexPaths());
        ArrayList<SubtreeEditor> editors = new ArrayList<SubtreeEditor>(indexPaths.size());
        for (final String path : indexPaths) {
            editors.add(new SubtreeEditor((Editor)new DefaultEditor(){

                public void leave(NodeState before, NodeState after) {
                    try {
                        if (IndexTracker.isStatusChanged(before, after) || IndexTracker.isIndexDefinitionChanged(before, after)) {
                            long start = PERF_LOGGER.start();
                            LuceneIndexNodeManager index = LuceneIndexNodeManager.open(path, root, after, IndexTracker.this.readerFactory, IndexTracker.this.nrtFactory);
                            PERF_LOGGER.end(start, -1L, "[{}] Index found to be updated. Reopening the LuceneIndexNode", (Object)path);
                            updates.put(path, index);
                        }
                    }
                    catch (IOException e) {
                        IndexTracker.this.badIndexTracker.markBadPersistedIndex(path, e);
                    }
                }
            }, (String[])IterableUtils.toArray((Iterable)PathUtils.elements((String)path), String.class)));
        }
        EditorDiff.process((Editor)CompositeEditor.compose(editors), (NodeState)this.root, (NodeState)root);
        this.root = root;
        if (!updates.isEmpty()) {
            HashMap builder = new HashMap();
            builder.putAll(MapUtils.filterKeys(original, x -> !updates.containsKey(x)));
            builder.putAll(MapUtils.filterValues(updates, Objects::nonNull));
            this.indices = Collections.unmodifiableMap(builder);
            this.badIndexTracker.markGoodIndexes(updates.keySet());
            for (String path : updates.keySet()) {
                LuceneIndexNodeManager index = original.get(path);
                try {
                    if (index == null) continue;
                    index.close();
                }
                catch (IOException e) {
                    log.error("Failed to close Lucene index at {}", (Object)path, (Object)e);
                }
            }
        }
    }

    public void refresh() {
        log.info("Marked tracker to refresh upon next cycle");
        this.refresh = true;
    }

    @Nullable
    public LuceneIndexNode acquireIndexNode(String path) {
        LuceneIndexNode indexNode;
        LuceneIndexNodeManager index = this.indices.get(path);
        LuceneIndexNode luceneIndexNode = indexNode = index != null ? index.acquire() : null;
        if (indexNode != null) {
            return indexNode;
        }
        return this.findIndexNode(path);
    }

    @Nullable
    private synchronized LuceneIndexNode findIndexNode(String path) {
        LuceneIndexNodeManager index = this.indices.get(path);
        if (index != null) {
            LuceneIndexNode indexNode = index.acquire();
            return Objects.requireNonNull(indexNode);
        }
        if (this.badIndexTracker.isIgnoredBadIndex(path)) {
            return null;
        }
        NodeState node = this.root;
        for (String name : PathUtils.elements((String)path)) {
            node = node.getChildNode(name);
        }
        try {
            if (LuceneIndexHelper.isLuceneIndexNode(node)) {
                index = LuceneIndexNodeManager.open(path, this.root, node, this.readerFactory, this.nrtFactory);
                if (index != null) {
                    LuceneIndexNode indexNode = index.acquire();
                    Objects.requireNonNull(indexNode);
                    HashMap<String, LuceneIndexNodeManager> builder = new HashMap<String, LuceneIndexNodeManager>();
                    builder.putAll(this.indices);
                    builder.put(path, index);
                    this.indices = Collections.unmodifiableMap(builder);
                    this.badIndexTracker.markGoodIndex(path);
                    return indexNode;
                }
            } else if (node.exists()) {
                log.warn("Cannot open Lucene Index at path {} as the index is not of type {}", (Object)path, (Object)"lucene");
            }
        }
        catch (Throwable e) {
            this.badIndexTracker.markBadIndexForRead(path, e);
        }
        return null;
    }

    @Nullable
    public LuceneIndexDefinition getIndexDefinition(String indexPath) {
        LuceneIndexNodeManager indexNodeManager = this.indices.get(indexPath);
        if (indexNodeManager != null) {
            return indexNodeManager.getDefinition();
        }
        NodeState node = NodeStateUtils.getNode((NodeState)this.root, (String)indexPath);
        if (!node.exists()) {
            return null;
        }
        if (!node.hasChildNode(":index-definition")) {
            return null;
        }
        if (!LuceneIndexHelper.isLuceneIndexNode(node)) {
            return null;
        }
        return new LuceneIndexDefinition(this.root, node, indexPath);
    }

    public Set<String> getIndexNodePaths() {
        return this.indices.keySet();
    }

    public BadIndexTracker getBadIndexTracker() {
        return this.badIndexTracker;
    }

    public NodeState getRoot() {
        return this.root;
    }

    private static boolean isStatusChanged(NodeState before, NodeState after) {
        return !EqualsDiff.equals((NodeState)before.getChildNode(":status"), (NodeState)after.getChildNode(":status"));
    }

    private static boolean isIndexDefinitionChanged(NodeState before, NodeState after) {
        return !EqualsDiff.equals((NodeState)before.getChildNode(":index-definition"), (NodeState)after.getChildNode(":index-definition"));
    }
}

