/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.multimap.ArrayListValuedLinkedHashMap;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.spi.FulltextQueryTermsProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.spi.IndexFieldProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.LoggerFactory;

@Component(service={IndexAugmentorFactory.class}, reference={@Reference(name="IndexFieldProvider", bind="bindIndexFieldProvider", unbind="unbindIndexFieldProvider", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, service=IndexFieldProvider.class), @Reference(name="FulltextQueryTermsProvider", bind="bindFulltextQueryTermsProvider", unbind="unbindFulltextQueryTermsProvider", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, service=FulltextQueryTermsProvider.class)})
public class IndexAugmentorFactory {
    private static final PerfLogger PERFLOG = new PerfLogger(LoggerFactory.getLogger((String)(IndexAugmentorFactory.class.getName() + ".perf")));
    private final Set<IndexFieldProvider> indexFieldProviders = SetUtils.newIdentityHashSet();
    private final Set<FulltextQueryTermsProvider> fulltextQueryTermsProviders = SetUtils.newIdentityHashSet();
    private volatile Map<String, CompositeIndexFieldProvider> indexFieldProviderMap;
    private volatile Map<String, CompositeFulltextQueryTermsProvider> fulltextQueryTermsProviderMap;

    public IndexAugmentorFactory() {
        this.resetState();
    }

    @Deactivate
    private synchronized void deactivate() {
        this.resetState();
    }

    @NotNull
    public IndexFieldProvider getIndexFieldProvider(String nodeType) {
        IndexFieldProvider provider = this.indexFieldProviderMap.get(nodeType);
        return provider != null ? provider : IndexFieldProvider.DEFAULT;
    }

    @NotNull
    public FulltextQueryTermsProvider getFulltextQueryTermsProvider(String nodeType) {
        FulltextQueryTermsProvider provider = this.fulltextQueryTermsProviderMap.get(nodeType);
        return provider != null ? provider : FulltextQueryTermsProvider.DEFAULT;
    }

    synchronized void bindIndexFieldProvider(IndexFieldProvider indexFieldProvider) {
        this.indexFieldProviders.add(indexFieldProvider);
        this.refreshIndexFieldProviders();
    }

    synchronized void unbindIndexFieldProvider(IndexFieldProvider indexFieldProvider) {
        this.indexFieldProviders.remove(indexFieldProvider);
        this.refreshIndexFieldProviders();
    }

    synchronized void bindFulltextQueryTermsProvider(FulltextQueryTermsProvider fulltextQueryTermsProvider) {
        this.fulltextQueryTermsProviders.add(fulltextQueryTermsProvider);
        this.refreshFulltextQueryTermsProviders();
    }

    synchronized void unbindFulltextQueryTermsProvider(FulltextQueryTermsProvider fulltextQueryTermsProvider) {
        this.fulltextQueryTermsProviders.remove(fulltextQueryTermsProvider);
        this.refreshFulltextQueryTermsProviders();
    }

    private void refreshIndexFieldProviders() {
        ArrayListValuedLinkedHashMap providerMultimap = new ArrayListValuedLinkedHashMap();
        for (IndexFieldProvider provider : this.indexFieldProviders) {
            Set<String> supportedNodeTypes = provider.getSupportedTypes();
            for (String nodeType : supportedNodeTypes) {
                providerMultimap.put((Object)nodeType, (Object)provider);
            }
        }
        HashMap<String, CompositeIndexFieldProvider> providerMap = new HashMap<String, CompositeIndexFieldProvider>();
        for (String nodeType : providerMultimap.keySet()) {
            List providers = providerMultimap.get((Object)nodeType);
            CompositeIndexFieldProvider compositeIndexFieldProvider = new CompositeIndexFieldProvider(nodeType, providers);
            providerMap.put(nodeType, compositeIndexFieldProvider);
        }
        this.indexFieldProviderMap = Collections.unmodifiableMap(providerMap);
    }

    private void refreshFulltextQueryTermsProviders() {
        ArrayListValuedLinkedHashMap providerMultimap = new ArrayListValuedLinkedHashMap();
        for (FulltextQueryTermsProvider provider : this.fulltextQueryTermsProviders) {
            Set<String> supportedNodeTypes = provider.getSupportedTypes();
            for (String nodeType : supportedNodeTypes) {
                providerMultimap.put((Object)nodeType, (Object)provider);
            }
        }
        HashMap<String, CompositeFulltextQueryTermsProvider> providerMap = new HashMap<String, CompositeFulltextQueryTermsProvider>();
        for (String nodeType : providerMultimap.keySet()) {
            List providers = providerMultimap.get((Object)nodeType);
            CompositeFulltextQueryTermsProvider compositeFulltextQueryTermsProvider = new CompositeFulltextQueryTermsProvider(nodeType, providers);
            providerMap.put(nodeType, compositeFulltextQueryTermsProvider);
        }
        this.fulltextQueryTermsProviderMap = Collections.unmodifiableMap(providerMap);
    }

    private void resetState() {
        this.indexFieldProviders.clear();
        this.fulltextQueryTermsProviders.clear();
        this.indexFieldProviderMap = Collections.emptyMap();
        this.fulltextQueryTermsProviderMap = Collections.emptyMap();
    }

    boolean isStateEmpty() {
        return this.indexFieldProviders.size() == 0 && this.indexFieldProviderMap.size() == 0 && this.fulltextQueryTermsProviders.size() == 0 && this.fulltextQueryTermsProviderMap.size() == 0;
    }

    class CompositeFulltextQueryTermsProvider
    implements FulltextQueryTermsProvider {
        private final String nodeType;
        private final List<FulltextQueryTermsProvider> providers;

        CompositeFulltextQueryTermsProvider(String nodeType, List<FulltextQueryTermsProvider> providers) {
            this.nodeType = nodeType;
            this.providers = List.copyOf(providers);
        }

        @Override
        public Query getQueryTerm(String text, Analyzer analyzer, NodeState indexDefinition) {
            Query ret;
            ArrayList<Query> subQueries = new ArrayList<Query>();
            for (FulltextQueryTermsProvider fulltextQueryTermsProvider : this.providers) {
                long start = PERFLOG.start();
                Query subQuery = fulltextQueryTermsProvider.getQueryTerm(text, analyzer, indexDefinition);
                PERFLOG.end(start, 1L, "fulltextQueryTermsProvider: {}, text: {}", (Object)fulltextQueryTermsProvider, (Object)text);
                if (subQuery == null) continue;
                subQueries.add(subQuery);
            }
            if (subQueries.size() == 0) {
                ret = null;
            } else if (subQueries.size() == 1) {
                ret = (Query)subQueries.get(0);
            } else {
                BooleanQuery query = new BooleanQuery();
                for (Query subQuery : subQueries) {
                    query.add(subQuery, BooleanClause.Occur.SHOULD);
                }
                ret = query;
            }
            return ret;
        }

        @Override
        @NotNull
        public Set<String> getSupportedTypes() {
            return Collections.singleton(this.nodeType);
        }
    }

    class CompositeIndexFieldProvider
    implements IndexFieldProvider {
        private final String nodeType;
        private final List<IndexFieldProvider> providers;

        CompositeIndexFieldProvider(String nodeType, List<IndexFieldProvider> providers) {
            this.nodeType = nodeType;
            this.providers = List.copyOf(providers);
        }

        @NotNull
        public List<Field> getAugmentedFields(String path, NodeState document, NodeState indexDefinition) {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (IndexFieldProvider indexFieldProvider : this.providers) {
                long start = PERFLOG.start();
                Iterable<Field> providedFields = indexFieldProvider.getAugmentedFields(path, document, indexDefinition);
                PERFLOG.end(start, 1L, "indexFieldProvider: {}, path: {}, doc: {}, indexDef: {}", new Object[]{indexFieldProvider, path, document, indexDefinition});
                for (Field f : providedFields) {
                    fields.add(f);
                }
            }
            return fields;
        }

        @Override
        @NotNull
        public Set<String> getSupportedTypes() {
            return Collections.singleton(this.nodeType);
        }
    }
}

