/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.oak.api.jmx.RepositoryManagementMBean;
import org.apache.jackrabbit.oak.jcr.session.SessionSaveDelayerConfig;
import org.apache.jackrabbit.oak.spi.toggle.Feature;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionSaveDelayer
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SessionSaveDelayer.class);
    private static final String FT_SAVE_DELAY_NAME = "FT_SAVE_DELAY_OAK-11766";
    private static final String ENABLED_PROP_NAME = "oak.sessionSaveDelayer";
    private static final String CONFIG_PROP_NAME = "oak.sessionSaveDelayerConfig";
    private final boolean enabledViaSysPropertey = Boolean.getBoolean("oak.sessionSaveDelayer");
    private final String sysPropertyConfig = System.getProperty("oak.sessionSaveDelayerConfig", "");
    private final Feature feature;
    private final Whiteboard whiteboard;
    private final AtomicBoolean closed = new AtomicBoolean();
    private RepositoryManagementMBean cachedMbean;
    private String lastConfigJson;
    private SessionSaveDelayerConfig lastConfig;
    private volatile boolean logNextDelay;

    public SessionSaveDelayer(@NotNull Whiteboard whiteboard) {
        this.feature = Feature.newFeature((String)FT_SAVE_DELAY_NAME, (Whiteboard)whiteboard);
        LOG.info("Initialized");
        if (this.enabledViaSysPropertey) {
            LOG.info("Enabled via system property: oak.sessionSaveDelayer");
        }
        this.whiteboard = whiteboard;
    }

    private RepositoryManagementMBean getRepositoryMBean() {
        if (this.cachedMbean == null) {
            this.cachedMbean = (RepositoryManagementMBean)WhiteboardUtils.getService((Whiteboard)this.whiteboard, RepositoryManagementMBean.class);
        }
        return this.cachedMbean;
    }

    public long delayIfNeeded(String userData) {
        String jmxConfig;
        if (this.closed.get() || !this.feature.isEnabled() && !this.enabledViaSysPropertey) {
            return 0L;
        }
        String config = this.sysPropertyConfig;
        RepositoryManagementMBean mbean = this.getRepositoryMBean();
        if (mbean != null && !StringUtils.isEmpty((CharSequence)(jmxConfig = mbean.getSessionSaveDelayerConfig()))) {
            config = jmxConfig;
        }
        if (StringUtils.isEmpty((CharSequence)config)) {
            return 0L;
        }
        if (!config.equals(this.lastConfigJson)) {
            this.logNextDelay = true;
            this.lastConfigJson = config;
            try {
                this.lastConfig = null;
                this.lastConfig = SessionSaveDelayerConfig.fromJson(config);
                LOG.info("New config: {}", (Object)this.lastConfig.toString());
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Can not parse config {}", (Throwable)e);
                return 0L;
            }
        }
        if (this.lastConfig == null) {
            return 0L;
        }
        String threadName = Thread.currentThread().getName();
        long delayNanos = this.lastConfig.getDelayNanos(threadName, userData, null);
        if (delayNanos > 0L) {
            long millis = delayNanos / 1000000L;
            int nanos = (int)(delayNanos % 1000000L);
            if (this.logNextDelay) {
                LOG.info("Sleep {} ms {} ns for user {}", new Object[]{millis, nanos, userData});
                this.logNextDelay = false;
            }
            try {
                Thread.sleep(millis, nanos);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return delayNanos;
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.feature.close();
        }
    }
}

