/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InheritedMembershipIterator
extends AbstractLazyIterator<Group> {
    private static final Logger log = LoggerFactory.getLogger(InheritedMembershipIterator.class);
    private final Iterator<Group> groupIterator;
    private final List<Iterator<Group>> inherited = new ArrayList<Iterator<Group>>();
    private final Set<String> processed = new HashSet<String>();
    private Iterator<Group> inheritedIterator = null;

    InheritedMembershipIterator(@NotNull Iterator<Group> groupIterator) {
        this.groupIterator = groupIterator;
    }

    @Nullable
    protected Group getNext() {
        if (this.groupIterator.hasNext()) {
            Group gr = this.groupIterator.next();
            try {
                Iterator it = gr.memberOf();
                if (it.hasNext()) {
                    this.inherited.add(it);
                }
            }
            catch (RepositoryException e) {
                log.error("Failed to retrieve membership of group {}", (Object)gr, (Object)e);
            }
            return gr;
        }
        while (this.inheritedHasNext()) {
            Group gr = this.inheritedIterator.next();
            if (!this.notProcessedBefore(gr)) continue;
            return gr;
        }
        return null;
    }

    private boolean notProcessedBefore(@NotNull Group group) {
        try {
            return this.processed.add(group.getID()) && !"everyone".equals(group.getPrincipal().getName());
        }
        catch (RepositoryException repositoryException) {
            return true;
        }
    }

    private boolean inheritedHasNext() {
        if (this.inheritedIterator == null) {
            this.inheritedIterator = this.getNextInheritedIterator();
        }
        if (this.inheritedIterator.hasNext()) {
            return true;
        }
        this.inheritedIterator = this.getNextInheritedIterator();
        return this.inheritedIterator.hasNext();
    }

    @NotNull
    private Iterator<Group> getNextInheritedIterator() {
        if (this.inherited.isEmpty()) {
            return Collections.emptyIterator();
        }
        return this.inherited.remove(0);
    }
}

