/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.util.Map;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalIdentityConstants;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExternalIdentityValidatorProvider
extends ValidatorProvider
implements ExternalIdentityConstants {
    private static final Map<Integer, String> ERROR_MSGS = Map.of(70, "Attempt to create, modify or remove the system property 'rep:externalPrincipalNames'", 71, "Property 'rep:externalPrincipalNames' must be multi-valued of type STRING.", 72, "Property 'rep:externalPrincipalNames' requires 'rep:externalId' to be present on the Node.", 73, "Property 'rep:externalId' cannot be removed as long as 'rep:externalPrincipalNames' is present.", 74, "Attempt to add, modify or remove the system maintained property 'rep:externalId'.", 75, "Property 'rep:externalId' may only have a single value of type STRING.");
    private final boolean isSystem;
    private final boolean protectedExternalIds;

    ExternalIdentityValidatorProvider(boolean isSystem, boolean protectExternalIds) {
        this.isSystem = isSystem;
        this.protectedExternalIds = protectExternalIds;
    }

    protected Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        return new ExternalIdentityValidator(after, true);
    }

    private final class ExternalIdentityValidator
    extends DefaultValidator {
        private final NodeState parent;
        private final boolean modifiedParent;

        private ExternalIdentityValidator(NodeState parent, boolean modifiedParent) {
            this.parent = parent;
            this.modifiedParent = modifiedParent;
        }

        public void propertyAdded(PropertyState after) throws CommitFailedException {
            this.checkAddModifyProperties(this.parent, after.getName(), after, this.modifiedParent);
        }

        public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
            this.checkAddModifyProperties(this.parent, before.getName(), after, this.modifiedParent);
        }

        private void checkAddModifyProperties(@NotNull NodeState parent, @NotNull String name, @NotNull PropertyState propertyState, boolean isModify) throws CommitFailedException {
            if (!ExternalIdentityConstants.RESERVED_PROPERTY_NAMES.contains(name)) {
                return;
            }
            if ("rep:externalPrincipalNames".equals(name)) {
                this.checkIsSystem();
                if (!Type.STRINGS.equals((Object)propertyState.getType()) || !propertyState.isArray()) {
                    throw new CommitFailedException("Constraint", 71, ERROR_MSGS.get(71));
                }
                if (!parent.hasProperty("rep:externalId")) {
                    throw new CommitFailedException("Constraint", 72, ERROR_MSGS.get(72));
                }
            }
            if ("rep:externalId".equals(name) && ExternalIdentityValidatorProvider.this.protectedExternalIds) {
                if (isModify && !ExternalIdentityValidatorProvider.this.isSystem) {
                    throw new CommitFailedException("Constraint", 74, ERROR_MSGS.get(74));
                }
                if (!Type.STRING.equals((Object)propertyState.getType()) || propertyState.isArray()) {
                    throw new CommitFailedException("Constraint", 75, ERROR_MSGS.get(75));
                }
            }
        }

        public void propertyDeleted(PropertyState before) throws CommitFailedException {
            String name = before.getName();
            if (!ExternalIdentityConstants.RESERVED_PROPERTY_NAMES.contains(name)) {
                return;
            }
            if ("rep:externalPrincipalNames".equals(name)) {
                this.checkIsSystem();
            }
            if ("rep:externalId".equals(name)) {
                if (this.parent.hasProperty("rep:externalPrincipalNames")) {
                    throw new CommitFailedException("Constraint", 73, ERROR_MSGS.get(73));
                }
                if (ExternalIdentityValidatorProvider.this.protectedExternalIds && !ExternalIdentityValidatorProvider.this.isSystem) {
                    throw new CommitFailedException("Constraint", 74, ERROR_MSGS.get(74));
                }
            }
        }

        private void checkIsSystem() throws CommitFailedException {
            if (!ExternalIdentityValidatorProvider.this.isSystem) {
                throw new CommitFailedException("Constraint", 70, ERROR_MSGS.get(70));
            }
        }

        public Validator childNodeAdded(String name, NodeState after) {
            return new ExternalIdentityValidator(after, false);
        }

        public Validator childNodeChanged(String name, NodeState before, NodeState after) {
            return new ExternalIdentityValidator(after, true);
        }

        @Nullable
        public Validator childNodeDeleted(String name, NodeState before) {
            return null;
        }
    }
}

