/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import javax.jcr.Session;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.ExternalIdentityConstants;
import org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal.SystemPrincipalConfig;
import org.apache.jackrabbit.oak.spi.xml.PropInfo;
import org.apache.jackrabbit.oak.spi.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.oak.spi.xml.ReferenceChangeTracker;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalIdentityImporter
implements ProtectedPropertyImporter,
ExternalIdentityConstants {
    private static final Logger log = LoggerFactory.getLogger(ExternalIdentityImporter.class);
    private final SystemPrincipalConfig systemPrincipalConfig;
    private boolean isSystemSession;

    ExternalIdentityImporter(@NotNull SystemPrincipalConfig systemPrincipalConfig) {
        this.systemPrincipalConfig = systemPrincipalConfig;
    }

    public boolean init(@NotNull Session session, @NotNull Root root, @NotNull NamePathMapper namePathMapper, boolean isWorkspaceImport, int uuidBehavior, @NotNull ReferenceChangeTracker referenceTracker, @NotNull SecurityProvider securityProvider) {
        this.isSystemSession = this.systemPrincipalConfig.containsSystemPrincipal(root.getContentSession().getAuthInfo().getPrincipals());
        return true;
    }

    public void processReferences() {
    }

    public boolean handlePropInfo(@NotNull Tree parent, @NotNull PropInfo protectedPropInfo, @NotNull PropertyDefinition def) {
        return false;
    }

    public void propertiesCompleted(@NotNull Tree protectedParent) {
        if (!this.isSystemSession && protectedParent.hasProperty("rep:externalPrincipalNames")) {
            log.debug("Found reserved property {} managed by the system => Removed from imported scope.", (Object)"rep:externalPrincipalNames");
            protectedParent.removeProperty("rep:externalPrincipalNames");
            protectedParent.removeProperty("rep:lastSynced");
        }
    }
}

