/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CachedGroupPrincipal
extends PrincipalImpl
implements GroupPrincipal,
ItemBasedPrincipal {
    private static final Logger log = LoggerFactory.getLogger(CachedGroupPrincipal.class);
    private Group group;
    private UserManager userManager;

    public CachedGroupPrincipal(@NotNull String principalName, @NotNull UserManager userManager) {
        super(principalName);
        this.userManager = userManager;
    }

    public boolean isMember(@NotNull Principal principal) {
        boolean isMember = false;
        try {
            Authorizable a = this.userManager.getAuthorizable(principal);
            if (a != null) {
                Group g = this.getGroup();
                return g != null && g.isMember(a);
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to determine group membership: {}", (Object)e.getMessage());
        }
        return isMember;
    }

    @NotNull
    public Enumeration<? extends Principal> members() {
        Iterator members;
        try {
            Group g = this.getGroup();
            members = g == null ? Collections.emptyIterator() : g.getMembers();
        }
        catch (RepositoryException e) {
            String msg = "Unable to retrieve Group members: " + e.getMessage();
            log.error(msg);
            throw new IllegalStateException(msg, e);
        }
        Iterator principals = IteratorUtils.transform((Iterator)members, authorizable -> {
            if (authorizable == null) {
                return null;
            }
            try {
                return authorizable.getPrincipal();
            }
            catch (RepositoryException e) {
                String msg = "Internal error while retrieving principal: " + e.getMessage();
                log.error(msg);
                throw new IllegalStateException(msg, e);
            }
        });
        return IteratorUtils.asEnumeration((Iterator)IteratorUtils.filter((Iterator)principals, Objects::nonNull));
    }

    private Group getGroup() throws RepositoryException {
        Authorizable authorizable;
        if (this.group == null && (authorizable = this.userManager.getAuthorizable((Principal)new PrincipalImpl(this.getName()))) != null && authorizable.isGroup()) {
            this.group = (Group)authorizable;
        }
        return this.group;
    }

    @NotNull
    public String getPath() throws RepositoryException {
        return this.getGroup().getPath();
    }
}

