/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.impl.principal;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.AutoMembershipConfig;
import org.apache.jackrabbit.oak.spi.security.principal.GroupPrincipals;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AutoMembershipPrincipals {
    private static final Logger log = LoggerFactory.getLogger(AutoMembershipPrincipals.class);
    private final UserManager userManager;
    private final Map<String, String[]> autoMembershipMapping;
    private final Map<String, AutoMembershipConfig> autoMembershipConfigMap;
    private final Map<String, Set<Principal>> principalMap;

    AutoMembershipPrincipals(@NotNull UserManager userManager, @NotNull Map<String, String[]> autoMembershipMapping, @NotNull Map<String, AutoMembershipConfig> autoMembershipConfigMap) {
        this.userManager = userManager;
        this.autoMembershipMapping = autoMembershipMapping;
        this.autoMembershipConfigMap = autoMembershipConfigMap;
        this.principalMap = new ConcurrentHashMap<String, Set<Principal>>(autoMembershipMapping.size());
    }

    Set<String> getConfiguredIdpNames(@NotNull Principal groupPrincipal) {
        if (this.principalMap.isEmpty() && !this.autoMembershipMapping.isEmpty()) {
            for (String idpName2 : this.autoMembershipMapping.keySet()) {
                this.collectGlobalAutoMembershipPrincipals(idpName2);
            }
        }
        String name = groupPrincipal.getName();
        HashSet<String> idpNames = new HashSet<String>(this.principalMap.size());
        this.principalMap.forEach((idpName, principals) -> {
            if (principals.stream().anyMatch(principal -> name.equals(principal.getName()))) {
                idpNames.add((String)idpName);
            }
        });
        return idpNames;
    }

    @NotNull
    Iterator<Authorizable> getMembersFromAutoMembershipConfig(@NotNull Group group) {
        ArrayList results = new ArrayList();
        this.autoMembershipConfigMap.values().forEach(autoMembershipConfig -> results.add(autoMembershipConfig.getAutoMembers(this.userManager, group)));
        return IteratorUtils.chainedIterator(results.iterator());
    }

    boolean isMember(@NotNull String idpName, @NotNull String groupId, @NotNull Authorizable authorizable) {
        AutoMembershipConfig config;
        String[] vs = this.autoMembershipMapping.get(idpName);
        if (vs != null) {
            for (String grId : vs) {
                if (!groupId.equals(grId)) continue;
                return true;
            }
        }
        if ((config = this.autoMembershipConfigMap.get(idpName)) != null) {
            return config.getAutoMembership(authorizable).contains(groupId);
        }
        return false;
    }

    boolean isInheritedMember(@NotNull String idpName, @NotNull Group group, @NotNull Authorizable authorizable) throws RepositoryException {
        AutoMembershipConfig config;
        String groupId = group.getID();
        if (this.isMember(idpName, groupId, authorizable)) {
            return true;
        }
        HashSet<String> automembershipIds = new HashSet<String>();
        if (this.autoMembershipMapping.containsKey(idpName)) {
            automembershipIds.addAll(Arrays.asList(this.autoMembershipMapping.get(idpName)));
        }
        if ((config = this.autoMembershipConfigMap.get(idpName)) != null) {
            automembershipIds.addAll(config.getAutoMembership(authorizable));
        }
        HashSet<String> processed = new HashSet<String>();
        for (String automembershipId : automembershipIds) {
            Authorizable gr = this.userManager.getAuthorizable(automembershipId);
            if (gr == null || !gr.isGroup()) {
                log.warn("Configured automembership id '{}' is not a valid group", (Object)automembershipId);
                continue;
            }
            if (!AutoMembershipPrincipals.hasInheritedMembership(gr.declaredMemberOf(), groupId, automembershipId, processed, "> ")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInheritedMembership(@NotNull Iterator<Group> declared, @NotNull String groupId, @NotNull String memberId, @NotNull Set<String> processed, @NotNull String trace) throws RepositoryException {
        ArrayList<Group> groups = new ArrayList<Group>();
        while (declared.hasNext()) {
            Group gr = declared.next();
            String grId = gr.getID();
            if (groupId.equals(grId)) {
                return true;
            }
            if (memberId.equals(grId)) {
                log.error("Cyclic group membership detected for group id {} via {}{}", new Object[]{memberId, trace, grId});
                continue;
            }
            if (!processed.add(grId)) continue;
            groups.add(gr);
        }
        for (Group group : groups) {
            if (!AutoMembershipPrincipals.hasInheritedMembership(group.declaredMemberOf(), groupId, memberId, processed, String.format("%s %s > ", trace, group.getID()))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Map<Principal, Group> getAutoMembership(@NotNull String idpName, @NotNull Authorizable authorizable, boolean includeInherited) {
        AutoMembershipConfig config;
        Map<Principal, Group> map = this.collectGlobalAutoMembershipPrincipals(idpName);
        if (includeInherited) {
            for (Group gr : map.values().toArray(new Group[0])) {
                AutoMembershipPrincipals.collectInheritedPrincipals(gr, map);
            }
        }
        if ((config = this.autoMembershipConfigMap.get(idpName)) != null) {
            config.getAutoMembership(authorizable).forEach(groupId -> this.addVerifiedPrincipal((String)groupId, map, includeInherited));
        }
        return map;
    }

    private Map<Principal, Group> collectGlobalAutoMembershipPrincipals(@NotNull String idpName) {
        HashMap<Principal, Group> map = new HashMap<Principal, Group>();
        if (!this.principalMap.containsKey(idpName)) {
            String[] vs = this.autoMembershipMapping.get(idpName);
            if (vs != null) {
                for (String groupId : vs) {
                    this.addVerifiedPrincipal(groupId, map, false);
                }
            }
            this.principalMap.put(idpName, Collections.unmodifiableSet(SetUtils.toLinkedSet(map.keySet())));
        } else {
            this.principalMap.get(idpName).forEach(groupPrincipal -> {
                Group gr = this.retrieveGroup((Principal)groupPrincipal);
                if (gr != null) {
                    map.put((Principal)groupPrincipal, gr);
                }
            });
        }
        return map;
    }

    private static void collectInheritedPrincipals(@NotNull Group group, @NotNull Map<Principal, Group> map) {
        try {
            Iterator groups = group.memberOf();
            while (groups.hasNext()) {
                Group gr = (Group)groups.next();
                Principal p = AutoMembershipPrincipals.getVerifiedPrincipal(gr);
                if (p == null) continue;
                map.put(p, gr);
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while resolving inherited auto-membership", (Throwable)e);
        }
    }

    private void addVerifiedPrincipal(@NotNull String groupId, @NotNull Map<Principal, Group> builder, boolean includeInherited) {
        try {
            Authorizable a = this.userManager.getAuthorizable(groupId);
            if (a == null || !a.isGroup()) {
                log.warn("Configured auto-membership group {} does not exist -> Ignoring", (Object)groupId);
                return;
            }
            Group group = (Group)a;
            Principal principal = AutoMembershipPrincipals.getVerifiedPrincipal(group);
            if (principal != null) {
                builder.put(principal, group);
                if (includeInherited) {
                    AutoMembershipPrincipals.collectInheritedPrincipals(group, builder);
                }
            }
        }
        catch (RepositoryException e) {
            log.debug("Failed to retrieved 'auto-membership' group with id {}", (Object)groupId, (Object)e);
        }
    }

    @Nullable
    private static Principal getVerifiedPrincipal(@NotNull Group group) throws RepositoryException {
        Principal grPrincipal = group.getPrincipal();
        if (GroupPrincipals.isGroup((Principal)grPrincipal)) {
            return grPrincipal;
        }
        log.warn("Principal of group {} is not of group type -> Ignoring", (Object)group.getID());
        return null;
    }

    @Nullable
    private Group retrieveGroup(@NotNull Principal principal) {
        try {
            Authorizable gr = this.userManager.getAuthorizable(principal);
            if (gr != null && gr.isGroup()) {
                return (Group)gr;
            }
            log.warn("Cannot retrieve group from principal {} -> Ignoring", (Object)principal);
        }
        catch (RepositoryException e) {
            log.debug("Failed to retrieved 'auto-membership' group for principal {}", (Object)principal.getName(), (Object)e);
        }
        return null;
    }
}

