/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class PrintOpTreeProcessor
implements NodeProcessor {
    private final PrintStream out;
    private final HashMap<Operator<? extends OperatorDesc>, Integer> opMap = new HashMap();
    private Integer curNum = 0;

    public PrintOpTreeProcessor() {
        this.out = System.out;
    }

    public PrintOpTreeProcessor(PrintStream o) {
        this.out = o;
    }

    private String getParents(Operator<? extends OperatorDesc> op) {
        StringBuilder ret = new StringBuilder("[");
        boolean first = true;
        if (op.getParentOperators() != null) {
            for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                if (!first) {
                    ret.append(",");
                }
                ret.append(this.opMap.get(parent));
                first = false;
            }
        }
        ret.append("]");
        return ret.toString();
    }

    private String getChildren(Operator<? extends OperatorDesc> op) {
        StringBuilder ret = new StringBuilder("[");
        boolean first = true;
        if (op.getChildOperators() != null) {
            for (Operator<OperatorDesc> child : op.getChildOperators()) {
                if (!first) {
                    ret.append(",");
                }
                ret.append(this.opMap.get(child));
                first = false;
            }
        }
        ret.append("]");
        return ret.toString();
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
        Operator op = (Operator)nd;
        if (this.opMap.get(op) == null) {
            Integer n = this.curNum;
            Integer n2 = this.curNum = Integer.valueOf(this.curNum + 1);
            this.opMap.put(op, n);
        }
        this.out.println("[" + this.opMap.get(op) + "] " + op.getClass().getName() + " =p=> " + this.getParents(op) + " =c=> " + this.getChildren(op));
        if (op.getConf() == null) {
            return null;
        }
        return null;
    }
}

