/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class DoubleColDivideLongColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;

    public DoubleColDivideLongColumn(int colNum1, int colNum2, int outputColumn) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public DoubleColDivideLongColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DoubleColumnVector inputColVector1 = (DoubleColumnVector)batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        double[] vector1 = inputColVector1.vector;
        long[] vector2 = inputColVector2.vector;
        double[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = inputColVector1.isRepeating && inputColVector2.isRepeating || inputColVector1.isRepeating && !inputColVector1.noNulls && inputColVector1.isNull[0] || inputColVector2.isRepeating && !inputColVector2.noNulls && inputColVector2.isNull[0];
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        boolean hasDivBy0 = false;
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            long denom = vector2[0];
            outputVector[0] = vector1[0] / (double)denom;
            hasDivBy0 = hasDivBy0 || denom == 0L;
        } else if (inputColVector1.isRepeating) {
            double vector1Value = vector1[0];
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    long denom = vector2[i];
                    outputVector[i] = vector1Value / (double)denom;
                    hasDivBy0 = hasDivBy0 || denom == 0L;
                }
            } else {
                int i;
                for (i = 0; i != n; ++i) {
                    outputVector[i] = vector1Value / (double)vector2[i];
                }
                for (i = 0; i != n; ++i) {
                    hasDivBy0 = hasDivBy0 || vector2[i] == 0L;
                }
            }
        } else if (inputColVector2.isRepeating) {
            long vector2Value = vector2[0];
            if (vector2Value == 0L) {
                outputColVector.noNulls = false;
                outputColVector.isRepeating = true;
                outputColVector.isNull[0] = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] / (double)vector2Value;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] / (double)vector2Value;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                long denom = vector2[i];
                outputVector[i] = vector1[i] / (double)denom;
                hasDivBy0 = hasDivBy0 || denom == 0L;
            }
        } else {
            int i;
            for (i = 0; i != n; ++i) {
                outputVector[i] = vector1[i] / (double)vector2[i];
            }
            for (i = 0; i != n; ++i) {
                hasDivBy0 = hasDivBy0 || vector2[i] == 0L;
            }
        }
        if (!hasDivBy0) {
            NullUtil.setNullDataEntriesDouble(outputColVector, batch.selectedInUse, sel, n);
        } else {
            NullUtil.setNullAndDivBy0DataEntriesDouble(outputColVector, batch.selectedInUse, sel, n, inputColVector2);
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "double";
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum1 + ", col " + this.colNum2;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("double"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

