/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.distributed;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.internal.cache.execute.InternalFunction;

public class IndexingInProgressFunction
implements InternalFunction<Object> {
    private static final long serialVersionUID = 1L;
    public static final String ID = IndexingInProgressFunction.class.getName();

    public void execute(FunctionContext<Object> context) {
        RegionFunctionContext ctx = (RegionFunctionContext)context;
        ResultSender resultSender = ctx.getResultSender();
        Region region = ctx.getDataSet();
        Cache cache = region.getCache();
        String indexName = (String)ctx.getArguments();
        if (indexName == null) {
            throw new IllegalArgumentException("Missing index name");
        }
        LuceneService luceneService = LuceneServiceProvider.get((GemFireCache)cache);
        LuceneIndex luceneIndex = luceneService.getIndex(indexName, region.getFullPath());
        if (luceneIndex == null) {
            resultSender.lastResult((Object)false);
        } else {
            resultSender.lastResult((Object)luceneIndex.isIndexingInProgress());
        }
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }
}

