/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.directory;

import java.io.File;
import java.util.Collection;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.InternalLuceneIndex;
import org.apache.geode.cache.lucene.internal.directory.RegionDirectory;
import org.apache.geode.cache.lucene.internal.filesystem.FileSystem;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;

public class DumpDirectoryFiles
implements InternalFunction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    public static final String ID = DumpDirectoryFiles.class.getSimpleName();

    public void execute(FunctionContext context) {
        RegionFunctionContext ctx = (RegionFunctionContext)context;
        if (!(context.getArguments() instanceof String[])) {
            throw new IllegalArgumentException("Arguments should be a string array");
        }
        String[] args = (String[])context.getArguments();
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected 2 arguments: exportLocation, indexName");
        }
        String exportLocation = args[0];
        String indexName = args[1];
        Region region = ctx.getDataSet();
        LuceneService service = LuceneServiceProvider.get((GemFireCache)ctx.getDataSet().getCache());
        InternalLuceneIndex index = (InternalLuceneIndex)service.getIndex(indexName, region.getFullPath());
        if (index == null) {
            throw new IllegalStateException("Index not found for region " + region + " index " + indexName);
        }
        RepositoryManager repoManager = index.getRepositoryManager();
        try {
            Collection<IndexRepository> repositories = repoManager.getRepositories(ctx);
            repositories.stream().forEach(repo -> {
                IndexWriter writer = repo.getWriter();
                RegionDirectory directory = (RegionDirectory)writer.getDirectory();
                FileSystem fs = directory.getFileSystem();
                String bucketName = index.getName() + "_" + repo.getRegion().getFullPath();
                bucketName = bucketName.replace("/", "_");
                File bucketDirectory = new File(exportLocation, bucketName);
                bucketDirectory.mkdirs();
                fs.export(bucketDirectory);
            });
            context.getResultSender().lastResult(null);
        }
        catch (BucketNotFoundException e) {
            throw new FunctionException((Throwable)e);
        }
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return true;
    }
}

