/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.lucene.LuceneIndexDestroyedException;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.IndexRepositoryFactory;
import org.apache.geode.cache.lucene.internal.InternalLuceneIndex;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationInProgressException;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.RepositoryManager;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.execute.InternalRegionFunctionContext;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class PartitionedRepositoryManager
implements RepositoryManager {
    private final Logger logger = LogService.getLogger();
    public static IndexRepositoryFactory indexRepositoryFactory = new IndexRepositoryFactory();
    protected final ConcurrentHashMap<Integer, IndexRepository> indexRepositories = new ConcurrentHashMap();
    protected PartitionedRegion userRegion = null;
    protected final LuceneSerializer serializer;
    protected final InternalLuceneIndex index;
    protected volatile boolean closed;
    private final CountDownLatch isDataRegionReady = new CountDownLatch(1);
    private final ExecutorService waitingThreadPoolFromDM;

    public PartitionedRepositoryManager(InternalLuceneIndex index, LuceneSerializer serializer, ExecutorService waitingThreadPool) {
        this.index = index;
        this.serializer = serializer;
        this.closed = false;
        this.waitingThreadPoolFromDM = waitingThreadPool;
    }

    public void setUserRegionForRepositoryManager(PartitionedRegion userRegion) {
        this.userRegion = userRegion;
    }

    @Override
    public Collection<IndexRepository> getRepositories(RegionFunctionContext ctx) throws BucketNotFoundException {
        return this.getRepositories(ctx, false);
    }

    @Override
    public Collection<IndexRepository> getRepositories(RegionFunctionContext ctx, boolean waitForRepository) throws BucketNotFoundException {
        Region region = ctx.getDataSet();
        Set buckets = ((InternalRegionFunctionContext)ctx).getLocalBucketSet(region);
        ArrayList<IndexRepository> repos = new ArrayList<IndexRepository>(buckets.size());
        for (Integer bucketId : buckets) {
            BucketRegion userBucket = this.userRegion.getDataStore().getLocalBucketById(bucketId);
            if (userBucket == null) {
                throw new BucketNotFoundException("User bucket was not found for region " + region + "bucket id " + bucketId);
            }
            if (this.index.isIndexAvailable(userBucket.getId()) || userBucket.isEmpty() || waitForRepository) {
                repos.add(this.getRepository(userBucket.getId()));
                continue;
            }
            this.waitingThreadPoolFromDM.execute(() -> {
                try {
                    this.getRepository(userBucket.getId());
                }
                catch (Exception e) {
                    this.logger.debug("Lucene Index creation in progress.", (Throwable)e);
                }
            });
            throw new LuceneIndexCreationInProgressException("Lucene Index creation in progress for bucket: " + userBucket.getId());
        }
        return repos;
    }

    @Override
    public IndexRepository getRepository(Region region, Object key, Object callbackArg) throws BucketNotFoundException {
        BucketRegion userBucket = this.userRegion.getBucketRegion(key, callbackArg);
        if (userBucket == null) {
            throw new BucketNotFoundException("User bucket was not found for region " + region + "key " + key + " callbackarg " + callbackArg);
        }
        return this.getRepository(userBucket.getId());
    }

    protected IndexRepository getRepository(Integer bucketId) throws BucketNotFoundException {
        IndexRepository repo = this.indexRepositories.get(bucketId);
        if (repo != null && !repo.isClosed()) {
            return repo;
        }
        repo = this.computeRepository(bucketId);
        if (repo == null) {
            throw new BucketNotFoundException("Unable to find lucene index because no longer primary for bucket " + bucketId);
        }
        return repo;
    }

    protected IndexRepository computeRepository(Integer bucketId, LuceneSerializer serializer, InternalLuceneIndex index, PartitionedRegion userRegion, IndexRepository oldRepository) throws IOException {
        return indexRepositoryFactory.computeIndexRepository(bucketId, serializer, index, userRegion, oldRepository, this);
    }

    protected IndexRepository computeRepository(Integer bucketId) {
        try {
            this.isDataRegionReady.await();
        }
        catch (InterruptedException e) {
            throw new InternalGemFireError("Unable to create index repository", (Throwable)e);
        }
        IndexRepository repo = this.indexRepositories.compute(bucketId, (key, oldRepository) -> {
            try {
                if (this.closed) {
                    if (oldRepository != null) {
                        oldRepository.cleanup();
                    }
                    throw new LuceneIndexDestroyedException(this.index.getName(), this.index.getRegionPath());
                }
                return this.computeRepository(bucketId, this.serializer, this.index, this.userRegion, (IndexRepository)oldRepository);
            }
            catch (IOException e) {
                throw new InternalGemFireError("Unable to create index repository", (Throwable)e);
            }
        });
        return repo;
    }

    protected void allowRepositoryComputation() {
        this.isDataRegionReady.countDown();
    }

    @Override
    public void close() {
        this.closed = true;
        for (Integer bucketId : this.indexRepositories.keySet()) {
            try {
                this.computeRepository(bucketId);
            }
            catch (LuceneIndexDestroyedException luceneIndexDestroyedException) {}
        }
    }
}

