/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Instruction;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractDependencyFilter {
    private static final Pattern MISSING_KEY_PATTERN = Pattern.compile("(^|,)\\p{Blank}*(!)?\\p{Blank}*([a-zA-Z]+=)");
    private static final String PLACEHOLDER = "$$PLACEHOLDER$$";
    private final Collection<Artifact> m_dependencyArtifacts;

    public AbstractDependencyFilter(Collection<Artifact> dependencyArtifacts) {
        this.m_dependencyArtifacts = dependencyArtifacts;
    }

    protected final void processInstructions(String header) throws MojoExecutionException {
        Parameters instructions = OSGiHeader.parseHeader((String)MISSING_KEY_PATTERN.matcher(header).replaceAll("$1$2*;$3"));
        LinkedHashSet<Artifact> availableDependencies = new LinkedHashSet<Artifact>(this.m_dependencyArtifacts);
        Iterator clauseIterator = instructions.entrySet().iterator();
        while (clauseIterator.hasNext()) {
            String inline = "false";
            LinkedHashSet<Artifact> filteredDependencies = new LinkedHashSet<Artifact>(availableDependencies);
            Map.Entry clause = clauseIterator.next();
            String primaryKey = ((String)clause.getKey()).replaceFirst("~+$", "");
            boolean isNegative = primaryKey.startsWith("!");
            if (isNegative) {
                primaryKey = primaryKey.substring(1);
            }
            AndArtifactFilter andArtifactFilter = new AndArtifactFilter();
            if (!"*".equals(primaryKey)) {
                DependencyFilter filter = new DependencyFilter(primaryKey){

                    @Override
                    public boolean include(Artifact dependency) {
                        return super.matches(dependency.getArtifactId());
                    }
                };
                andArtifactFilter.add((ArtifactFilter)filter);
            }
            for (Map.Entry attr : ((Attrs)clause.getValue()).entrySet()) {
                DependencyFilter filter;
                if ("groupId".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        @Override
                        public boolean include(Artifact dependency) {
                            return super.matches(dependency.getGroupId());
                        }
                    };
                } else if ("artifactId".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        @Override
                        public boolean include(Artifact dependency) {
                            return super.matches(dependency.getArtifactId());
                        }
                    };
                } else if ("version".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue()){

                        @Override
                        public boolean include(Artifact dependency) {
                            try {
                                return super.matches(dependency.getSelectedVersion().toString());
                            }
                            catch (Exception e) {
                                return super.matches(dependency.getVersion());
                            }
                        }
                    };
                } else if ("scope".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "compile"){

                        @Override
                        public boolean include(Artifact dependency) {
                            return super.matches(dependency.getScope());
                        }
                    };
                } else if ("type".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "jar"){

                        @Override
                        public boolean include(Artifact dependency) {
                            return super.matches(dependency.getType());
                        }
                    };
                } else if ("classifier".equals(attr.getKey())) {
                    filter = new DependencyFilter("".equals(attr.getValue()) ? PLACEHOLDER : (String)attr.getValue()){

                        @Override
                        public boolean include(Artifact dependency) {
                            return super.matches(dependency.getClassifier() == null || "".equals(dependency.getClassifier()) ? AbstractDependencyFilter.PLACEHOLDER : dependency.getClassifier());
                        }
                    };
                } else if ("optional".equals(attr.getKey())) {
                    filter = new DependencyFilter((String)attr.getValue(), "false"){

                        @Override
                        public boolean include(Artifact dependency) {
                            return super.matches("" + dependency.isOptional());
                        }
                    };
                } else {
                    if ("inline".equals(attr.getKey())) {
                        inline = (String)attr.getValue();
                        continue;
                    }
                    throw new MojoExecutionException("Unexpected attribute " + (String)attr.getKey());
                }
                andArtifactFilter.add((ArtifactFilter)filter);
            }
            this.filteredDependencies((ArtifactFilter)andArtifactFilter, filteredDependencies);
            if (isNegative) {
                availableDependencies.removeAll(filteredDependencies);
                if (clauseIterator.hasNext()) continue;
                this.processDependencies(availableDependencies, inline);
                continue;
            }
            this.processDependencies(filteredDependencies, inline);
        }
    }

    protected abstract void processDependencies(Collection<Artifact> var1, String var2);

    private void filteredDependencies(ArtifactFilter artifactFilter, Collection<Artifact> filteredDependencies) {
        filteredDependencies.removeIf(artifact -> !artifactFilter.include(artifact));
    }

    private static abstract class DependencyFilter
    implements ArtifactFilter {
        private final Instruction m_instruction;
        private final String m_defaultValue;

        public DependencyFilter(String expression) {
            this(expression, "");
        }

        public DependencyFilter(String expression, String defaultValue) {
            this.m_instruction = new Instruction(expression);
            this.m_defaultValue = defaultValue;
        }

        public abstract boolean include(Artifact var1);

        boolean matches(String text) {
            boolean result = null == text ? this.m_instruction.matches(this.m_defaultValue) : this.m_instruction.matches(text);
            return this.m_instruction.isNegated() ? !result : result;
        }
    }
}

