/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.provider.remoting;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import org.apache.commons.proxy.ObjectProvider;
import org.apache.commons.proxy.exception.ObjectProviderException;

public class RmiProvider
implements ObjectProvider {
    private String host = "localhost";
    private int port = 1099;
    private RMIClientSocketFactory clientSocketFactory;
    private String name;

    public RmiProvider() {
    }

    public RmiProvider(String name) {
        this.setName(name);
    }

    public RmiProvider(String host, String name) {
        this.setHost(host);
        this.setName(name);
    }

    public RmiProvider(String host, int port, String name) {
        this.setHost(host);
        this.setName(name);
        this.setPort(port);
    }

    public RmiProvider(String host, int port, RMIClientSocketFactory clientSocketFactory, String name) {
        this.setHost(host);
        this.setPort(port);
        this.setClientSocketFactory(clientSocketFactory);
        this.setName(name);
    }

    public Object getObject() {
        Registry reg = null;
        try {
            reg = this.getRegistry();
            return reg.lookup(this.name);
        }
        catch (NotBoundException e) {
            throw new ObjectProviderException("Name " + this.name + " not found in registry at " + this.host + ":" + this.port + ".", e);
        }
        catch (RemoteException e) {
            throw new ObjectProviderException("Unable to lookup service named " + this.name + " in registry at " + this.host + ":" + this.port + ".", e);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClientSocketFactory(RMIClientSocketFactory clientSocketFactory) {
        this.clientSocketFactory = clientSocketFactory;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    private Registry getRegistry() {
        try {
            if (this.clientSocketFactory != null) {
                return LocateRegistry.getRegistry(this.host, this.port, this.clientSocketFactory);
            }
            return LocateRegistry.getRegistry(this.host, this.port);
        }
        catch (RemoteException e) {
            throw new ObjectProviderException("Unable to locate registry at " + this.host + ":" + this.port + ".", e);
        }
    }
}

