/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.calcite.avatica.util.PositionedCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IteratorCursor<E>
extends PositionedCursor<E> {
    private Position position = Position.BEFORE_START;
    private final Iterator<E> iterator;
    private E current = null;

    protected IteratorCursor(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean next() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            this.position = Position.OK;
            return true;
        }
        this.current = null;
        this.position = Position.AFTER_END;
        return false;
    }

    @Override
    public void close() {
        this.current = null;
        this.position = Position.CLOSED;
        if (this.iterator instanceof Closeable) {
            try {
                ((Closeable)((Object)this.iterator)).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected E current() {
        if (this.position != Position.OK) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Position {
        CLOSED,
        BEFORE_START,
        OK,
        AFTER_END;

    }
}

