/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.util;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.Cursor;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.Spacer;
import org.apache.calcite.avatica.util.TimeUnitRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCursor
implements Cursor {
    protected final boolean[] wasNull = new boolean[]{false};

    protected AbstractCursor() {
    }

    @Override
    public boolean wasNull() {
        return this.wasNull[0];
    }

    @Override
    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> types, Calendar localCalendar, ArrayImpl.Factory factory) {
        ArrayList<Cursor.Accessor> accessors = new ArrayList<Cursor.Accessor>();
        for (ColumnMetaData type : types) {
            accessors.add(this.createAccessor(type, accessors.size(), localCalendar, factory));
        }
        return accessors;
    }

    protected Cursor.Accessor createAccessor(ColumnMetaData type, int ordinal, Calendar localCalendar, ArrayImpl.Factory factory) {
        Getter getter = this.createGetter(ordinal);
        switch (type.type.type) {
            case -6: {
                return new ByteAccessor(getter);
            }
            case 5: {
                return new ShortAccessor(getter);
            }
            case 4: {
                return new IntAccessor(getter);
            }
            case -5: {
                return new LongAccessor(getter);
            }
            case 16: {
                return new BooleanAccessor(getter);
            }
            case 6: 
            case 7: {
                return new FloatAccessor(getter);
            }
            case 8: {
                return new DoubleAccessor(getter);
            }
            case 3: {
                return new BigDecimalAccessor(getter);
            }
            case 1: {
                switch (type.type.representation) {
                    case PRIMITIVE_CHAR: 
                    case CHARACTER: {
                        return new StringFromCharAccessor(getter, type.displaySize);
                    }
                }
                return new FixedStringAccessor(getter, type.displaySize);
            }
            case 12: {
                return new StringAccessor(getter);
            }
            case -3: 
            case -2: {
                return new BinaryAccessor(getter);
            }
            case 91: {
                switch (type.type.representation) {
                    case PRIMITIVE_INT: 
                    case INTEGER: {
                        return new DateFromIntAccessor(getter, localCalendar);
                    }
                    case JAVA_SQL_DATE: {
                        return new DateAccessor(getter, localCalendar);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)type.type.representation)));
            }
            case 92: {
                switch (type.type.representation) {
                    case PRIMITIVE_INT: 
                    case INTEGER: {
                        return new TimeFromIntAccessor(getter, localCalendar);
                    }
                    case JAVA_SQL_TIME: {
                        return new TimeAccessor(getter, localCalendar);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)type.type.representation)));
            }
            case 93: {
                switch (type.type.representation) {
                    case PRIMITIVE_LONG: 
                    case LONG: {
                        return new TimestampFromLongAccessor(getter, localCalendar);
                    }
                    case JAVA_SQL_TIMESTAMP: {
                        return new TimestampAccessor(getter, localCalendar);
                    }
                    case JAVA_UTIL_DATE: {
                        return new TimestampFromUtilDateAccessor(getter, localCalendar);
                    }
                }
                throw new AssertionError((Object)("bad " + (Object)((Object)type.type.representation)));
            }
            case 2003: {
                return new ArrayAccessor(getter, ((ColumnMetaData.ArrayType)type.type).component, factory);
            }
            case 1111: 
            case 2000: 
            case 2002: {
                if (type.type.typeName.startsWith("INTERVAL_")) {
                    TimeUnitRange range;
                    int end = type.type.typeName.indexOf("(");
                    if (end < 0) {
                        end = type.type.typeName.length();
                    }
                    if ((range = TimeUnitRange.valueOf(type.type.typeName.substring("INTERVAL_".length(), end))).monthly()) {
                        return new IntervalYearMonthAccessor(getter, range);
                    }
                    return new IntervalDayTimeAccessor(getter, range, type.scale);
                }
                return new ObjectAccessor(getter);
            }
        }
        throw new RuntimeException("unknown type " + type.type.type);
    }

    protected abstract Getter createGetter(int var1);

    @Override
    public abstract boolean next();

    private static String timestampAsString(long v, Calendar calendar) {
        if (calendar != null) {
            v -= (long)calendar.getTimeZone().getOffset(v);
        }
        return DateTimeUtils.unixTimestampToString(v);
    }

    private static String dateAsString(int v, Calendar calendar) {
        AvaticaUtils.discard(calendar);
        return DateTimeUtils.unixDateToString(v);
    }

    private static String timeAsString(int v, Calendar calendar) {
        if (calendar != null) {
            v -= calendar.getTimeZone().getOffset(v);
        }
        return DateTimeUtils.unixTimeToString(v);
    }

    private static Date longToDate(long v, Calendar calendar) {
        if (calendar != null) {
            v -= (long)calendar.getTimeZone().getOffset(v);
        }
        return new Date(v);
    }

    static Time intToTime(int v, Calendar calendar) {
        if (calendar != null) {
            v -= calendar.getTimeZone().getOffset(v);
        }
        return new Time(v);
    }

    static Timestamp longToTimestamp(long v, Calendar calendar) {
        if (calendar != null) {
            v -= (long)calendar.getTimeZone().getOffset(v);
        }
        return new Timestamp(v);
    }

    protected abstract class AbstractGetter
    implements Getter {
        protected AbstractGetter() {
        }

        public boolean wasNull() {
            return AbstractCursor.this.wasNull[0];
        }
    }

    protected static interface Getter {
        public Object getObject();

        public boolean wasNull();
    }

    private static class ObjectAccessor
    extends AccessorImpl {
        public ObjectAccessor(Getter getter) {
            super(getter);
        }
    }

    private static class ArrayAccessor
    extends AccessorImpl {
        private final ColumnMetaData.AvaticaType componentType;
        private final ArrayImpl.Factory factory;

        public ArrayAccessor(Getter getter, ColumnMetaData.AvaticaType componentType, ArrayImpl.Factory factory) {
            super(getter);
            this.componentType = componentType;
            this.factory = factory;
        }

        public Object getObject() {
            Object object = super.getObject();
            if (object == null || object instanceof List) {
                return object;
            }
            return AvaticaUtils.primitiveList(object);
        }

        public Array getArray() {
            List list = (List)this.getObject();
            if (list == null) {
                return null;
            }
            return new ArrayImpl(list, this.componentType, this.factory);
        }

        public String getString() {
            List o = (List)this.getObject();
            if (o == null) {
                return null;
            }
            Iterator iterator = o.iterator();
            if (!iterator.hasNext()) {
                return "[]";
            }
            StringBuilder buf = new StringBuilder("[");
            while (true) {
                this.append(buf, iterator.next());
                if (!iterator.hasNext()) {
                    return buf.append("]").toString();
                }
                buf.append(", ");
            }
        }

        private void append(StringBuilder buf, Object o) {
            if (o == null) {
                buf.append("null");
            } else if (o.getClass().isArray()) {
                this.append(buf, AvaticaUtils.primitiveList(o));
            } else {
                buf.append(o);
            }
        }
    }

    private static class IntervalDayTimeAccessor
    extends LongAccessor {
        private final TimeUnitRange range;
        private final int scale;

        public IntervalDayTimeAccessor(Getter getter, TimeUnitRange range, int scale) {
            super(getter);
            this.range = range;
            this.scale = scale;
        }

        public String getString() {
            long v = this.getLong();
            if (v == 0L && this.wasNull()) {
                return null;
            }
            return DateTimeUtils.intervalDayTimeToString(v, this.range, this.scale);
        }
    }

    private static class IntervalYearMonthAccessor
    extends IntAccessor {
        private final TimeUnitRange range;

        public IntervalYearMonthAccessor(Getter getter, TimeUnitRange range) {
            super(getter);
            this.range = range;
        }

        public String getString() {
            int v = this.getInt();
            if (v == 0 && this.wasNull()) {
                return null;
            }
            return DateTimeUtils.intervalYearMonthToString(v, this.range);
        }
    }

    private static class TimestampFromUtilDateAccessor
    extends ObjectAccessor {
        private final Calendar localCalendar;

        public TimestampFromUtilDateAccessor(Getter getter, Calendar localCalendar) {
            super(getter);
            this.localCalendar = localCalendar;
        }

        public Timestamp getTimestamp(Calendar calendar) {
            java.util.Date date = (java.util.Date)this.getObject();
            if (date == null) {
                return null;
            }
            long v = date.getTime();
            if (calendar != null) {
                v -= (long)calendar.getTimeZone().getOffset(v);
            }
            return new Timestamp(v);
        }

        public String getString() {
            java.util.Date date = (java.util.Date)this.getObject();
            if (date == null) {
                return null;
            }
            return AbstractCursor.timestampAsString(date.getTime(), null);
        }

        public long getLong() {
            Timestamp timestamp = this.getTimestamp(this.localCalendar);
            return timestamp == null ? 0L : timestamp.getTime();
        }
    }

    private static class TimestampAccessor
    extends ObjectAccessor {
        private final Calendar localCalendar;

        public TimestampAccessor(Getter getter, Calendar localCalendar) {
            super(getter);
            this.localCalendar = localCalendar;
        }

        public Timestamp getTimestamp(Calendar calendar) {
            Timestamp date = (Timestamp)this.getObject();
            if (date == null) {
                return null;
            }
            if (calendar != null) {
                long v = date.getTime();
                v -= (long)calendar.getTimeZone().getOffset(v);
                date = new Timestamp(v);
            }
            return date;
        }

        public String getString() {
            long v = this.getLong();
            if (v == 0L && this.wasNull()) {
                return null;
            }
            return AbstractCursor.timestampAsString(v, null);
        }

        public long getLong() {
            Timestamp timestamp = this.getTimestamp(null);
            return timestamp == null ? 0L : timestamp.getTime();
        }
    }

    private static class TimeAccessor
    extends ObjectAccessor {
        private final Calendar localCalendar;

        public TimeAccessor(Getter getter, Calendar localCalendar) {
            super(getter);
            this.localCalendar = localCalendar;
        }

        public Time getTime(Calendar calendar) {
            Time date = (Time)this.getObject();
            if (date == null) {
                return null;
            }
            if (calendar != null) {
                long v = date.getTime();
                v -= (long)calendar.getTimeZone().getOffset(v);
                date = new Time(v);
            }
            return date;
        }

        public String getString() {
            int v = this.getInt();
            if (v == 0 && this.wasNull()) {
                return null;
            }
            return AbstractCursor.timeAsString(v, null);
        }

        public long getLong() {
            Time time = this.getTime(null);
            return time == null ? 0L : time.getTime() % 86400000L;
        }
    }

    private static class DateAccessor
    extends ObjectAccessor {
        private final Calendar localCalendar;

        public DateAccessor(Getter getter, Calendar localCalendar) {
            super(getter);
            this.localCalendar = localCalendar;
        }

        public Date getDate(Calendar calendar) {
            Date date = (Date)this.getObject();
            if (date == null) {
                return null;
            }
            if (calendar != null) {
                long v = date.getTime();
                v -= (long)calendar.getTimeZone().getOffset(v);
                date = new Date(v);
            }
            return date;
        }

        public String getString() {
            int v = this.getInt();
            if (v == 0 && this.wasNull()) {
                return null;
            }
            return AbstractCursor.dateAsString(v, null);
        }

        public long getLong() {
            Date date = this.getDate(null);
            return date == null ? 0L : date.getTime() / 86400000L;
        }
    }

    private static class TimestampFromLongAccessor
    extends LongAccessor {
        private final Calendar localCalendar;

        public TimestampFromLongAccessor(Getter getter, Calendar localCalendar) {
            super(getter);
            this.localCalendar = localCalendar;
        }

        public Object getObject() {
            return this.getTimestamp(this.localCalendar);
        }

        public Timestamp getTimestamp(Calendar calendar) {
            long v = this.getLong();
            if (v == 0L && this.wasNull()) {
                return null;
            }
            return AbstractCursor.longToTimestamp(v, calendar);
        }

        public String getString() {
            long v = this.getLong();
            if (v == 0L && this.wasNull()) {
                return null;
            }
            return AbstractCursor.timestampAsString(v, null);
        }
    }

    private static class TimeFromIntAccessor
    extends IntAccessor {
        private final Calendar localCalendar;

        public TimeFromIntAccessor(Getter getter, Calendar localCalendar) {
            super(getter);
            this.localCalendar = localCalendar;
        }

        public Object getObject() {
            return this.getTime(this.localCalendar);
        }

        public Time getTime(Calendar calendar) {
            int v = this.getInt();
            if (v == 0 && this.wasNull()) {
                return null;
            }
            return AbstractCursor.intToTime(v, calendar);
        }

        public Timestamp getTimestamp(Calendar calendar) {
            long v = this.getLong();
            if (v == 0L && this.wasNull()) {
                return null;
            }
            return AbstractCursor.longToTimestamp(v, calendar);
        }

        public String getString() {
            int v = this.getInt();
            if (v == 0 && this.wasNull()) {
                return null;
            }
            return AbstractCursor.timeAsString(v, null);
        }
    }

    private static class DateFromIntAccessor
    extends IntAccessor {
        private final Calendar localCalendar;

        public DateFromIntAccessor(Getter getter, Calendar localCalendar) {
            super(getter);
            this.localCalendar = localCalendar;
        }

        public Object getObject() {
            return this.getDate(this.localCalendar);
        }

        public Date getDate(Calendar calendar) {
            int v = this.getInt();
            if (v == 0 && this.getter.wasNull()) {
                return null;
            }
            return AbstractCursor.longToDate((long)v * 86400000L, calendar);
        }

        public Timestamp getTimestamp(Calendar calendar) {
            int v = this.getInt();
            if (v == 0 && this.getter.wasNull()) {
                return null;
            }
            return AbstractCursor.longToTimestamp((long)v * 86400000L, calendar);
        }

        public String getString() {
            int v = this.getInt();
            if (v == 0 && this.wasNull()) {
                return null;
            }
            return AbstractCursor.dateAsString(v, null);
        }
    }

    private static class BinaryAccessor
    extends AccessorImpl {
        public BinaryAccessor(Getter getter) {
            super(getter);
        }

        public byte[] getBytes() {
            ByteString o = (ByteString)this.getObject();
            return o == null ? null : o.getBytes();
        }
    }

    private static class StringFromCharAccessor
    extends FixedStringAccessor {
        public StringFromCharAccessor(Getter getter, int length) {
            super(getter, length);
        }

        public String getString() {
            Character s = (Character)super.getObject();
            if (s == null) {
                return null;
            }
            return this.spacer.padRight(s.toString());
        }
    }

    private static class FixedStringAccessor
    extends StringAccessor {
        protected final Spacer spacer;

        public FixedStringAccessor(Getter getter, int length) {
            super(getter);
            this.spacer = new Spacer(length);
        }

        public String getString() {
            String s = super.getString();
            if (s == null) {
                return null;
            }
            return this.spacer.padRight(s);
        }
    }

    private static class StringAccessor
    extends AccessorImpl {
        public StringAccessor(Getter getter) {
            super(getter);
        }

        public String getString() {
            return (String)this.getObject();
        }
    }

    private static class BigDecimalAccessor
    extends BigNumberAccessor {
        public BigDecimalAccessor(Getter getter) {
            super(getter);
        }

        protected Number getNumber() {
            return (Number)this.getObject();
        }

        public BigDecimal getBigDecimal(int scale) {
            return (BigDecimal)this.getObject();
        }

        public BigDecimal getBigDecimal() {
            return (BigDecimal)this.getObject();
        }
    }

    private static abstract class BigNumberAccessor
    extends AccessorImpl {
        public BigNumberAccessor(Getter getter) {
            super(getter);
        }

        protected abstract Number getNumber();

        public double getDouble() {
            Number number = this.getNumber();
            return number == null ? 0.0 : number.doubleValue();
        }

        public float getFloat() {
            Number number = this.getNumber();
            return number == null ? 0.0f : number.floatValue();
        }

        public long getLong() {
            Number number = this.getNumber();
            return number == null ? 0L : number.longValue();
        }

        public int getInt() {
            Number number = this.getNumber();
            return number == null ? 0 : number.intValue();
        }

        public short getShort() {
            Number number = this.getNumber();
            return number == null ? (short)0 : number.shortValue();
        }

        public byte getByte() {
            Number number = this.getNumber();
            return number == null ? (byte)0 : number.byteValue();
        }

        public boolean getBoolean() {
            Number number = this.getNumber();
            return number != null && number.doubleValue() != 0.0;
        }
    }

    private static class DoubleAccessor
    extends ApproximateNumericAccessor {
        public DoubleAccessor(Getter getter) {
            super(getter);
        }

        public double getDouble() {
            Double o = (Double)this.getObject();
            return o == null ? 0.0 : o;
        }
    }

    private static class FloatAccessor
    extends ApproximateNumericAccessor {
        public FloatAccessor(Getter getter) {
            super(getter);
        }

        public float getFloat() {
            Float o = (Float)this.getObject();
            return o == null ? 0.0f : o.floatValue();
        }

        public double getDouble() {
            return this.getFloat();
        }
    }

    private static abstract class ApproximateNumericAccessor
    extends AccessorImpl {
        public ApproximateNumericAccessor(Getter getter) {
            super(getter);
        }

        public BigDecimal getBigDecimal(int scale) {
            double v = this.getDouble();
            if (v == 0.0 && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(v).setScale(scale, RoundingMode.DOWN);
        }

        public BigDecimal getBigDecimal() {
            double v = this.getDouble();
            if (v == 0.0 && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(v);
        }

        public abstract double getDouble();

        public long getLong() {
            return (long)this.getDouble();
        }
    }

    private static class LongAccessor
    extends ExactNumericAccessor {
        public LongAccessor(Getter getter) {
            super(getter);
        }

        public long getLong() {
            Long o = (Long)super.getObject();
            return o == null ? 0L : o;
        }
    }

    private static class IntAccessor
    extends ExactNumericAccessor {
        public IntAccessor(Getter getter) {
            super(getter);
        }

        public int getInt() {
            Integer o = (Integer)super.getObject();
            return o == null ? 0 : o;
        }

        public long getLong() {
            return this.getInt();
        }
    }

    private static class ShortAccessor
    extends ExactNumericAccessor {
        public ShortAccessor(Getter getter) {
            super(getter);
        }

        public short getShort() {
            Short o = (Short)this.getObject();
            return o == null ? (short)0 : o;
        }

        public long getLong() {
            return this.getShort();
        }
    }

    private static class ByteAccessor
    extends ExactNumericAccessor {
        public ByteAccessor(Getter getter) {
            super(getter);
        }

        public byte getByte() {
            Byte o = (Byte)this.getObject();
            return o == null ? (byte)0 : o;
        }

        public long getLong() {
            return this.getByte();
        }
    }

    private static class BooleanAccessor
    extends ExactNumericAccessor {
        public BooleanAccessor(Getter getter) {
            super(getter);
        }

        public boolean getBoolean() {
            Boolean o = (Boolean)this.getObject();
            return o != null && o != false;
        }

        public long getLong() {
            return this.getBoolean() ? 1L : 0L;
        }
    }

    private static abstract class ExactNumericAccessor
    extends AccessorImpl {
        public ExactNumericAccessor(Getter getter) {
            super(getter);
        }

        public BigDecimal getBigDecimal(int scale) {
            long v = this.getLong();
            if (v == 0L && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(v).setScale(scale, RoundingMode.DOWN);
        }

        public BigDecimal getBigDecimal() {
            long val = this.getLong();
            if (val == 0L && this.getter.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(val);
        }

        public double getDouble() {
            return this.getLong();
        }

        public float getFloat() {
            return this.getLong();
        }

        public abstract long getLong();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AccessorImpl
    implements Cursor.Accessor {
        protected final Getter getter;

        public AccessorImpl(Getter getter) {
            assert (getter != null);
            this.getter = getter;
        }

        @Override
        public boolean wasNull() {
            return this.getter.wasNull();
        }

        @Override
        public String getString() {
            Object o = this.getObject();
            return o == null ? null : o.toString();
        }

        @Override
        public boolean getBoolean() {
            return this.getLong() != 0L;
        }

        @Override
        public byte getByte() {
            return (byte)this.getLong();
        }

        @Override
        public short getShort() {
            return (short)this.getLong();
        }

        @Override
        public int getInt() {
            return (int)this.getLong();
        }

        @Override
        public long getLong() {
            throw this.cannotConvert("long");
        }

        @Override
        public float getFloat() {
            return (float)this.getDouble();
        }

        @Override
        public double getDouble() {
            throw this.cannotConvert("double");
        }

        @Override
        public BigDecimal getBigDecimal() {
            throw this.cannotConvert("BigDecimal");
        }

        @Override
        public BigDecimal getBigDecimal(int scale) {
            throw this.cannotConvert("BigDecimal with scale");
        }

        @Override
        public byte[] getBytes() {
            throw this.cannotConvert("byte[]");
        }

        @Override
        public InputStream getAsciiStream() {
            throw this.cannotConvert("InputStream (ascii)");
        }

        @Override
        public InputStream getUnicodeStream() {
            throw this.cannotConvert("InputStream (unicode)");
        }

        @Override
        public InputStream getBinaryStream() {
            throw this.cannotConvert("InputStream (binary)");
        }

        @Override
        public Object getObject() {
            return this.getter.getObject();
        }

        @Override
        public Reader getCharacterStream() {
            throw this.cannotConvert("Reader");
        }

        private RuntimeException cannotConvert(String targetType) {
            return new RuntimeException("cannot convert to " + targetType + " (" + this + ")");
        }

        @Override
        public Object getObject(Map<String, Class<?>> map) {
            throw this.cannotConvert("Object (with map)");
        }

        @Override
        public Ref getRef() {
            throw this.cannotConvert("Ref");
        }

        @Override
        public Blob getBlob() {
            throw this.cannotConvert("Blob");
        }

        @Override
        public Clob getClob() {
            throw this.cannotConvert("Clob");
        }

        @Override
        public Array getArray() {
            throw this.cannotConvert("Array");
        }

        @Override
        public Date getDate(Calendar calendar) {
            throw this.cannotConvert("Date");
        }

        @Override
        public Time getTime(Calendar calendar) {
            throw this.cannotConvert("Time");
        }

        @Override
        public Timestamp getTimestamp(Calendar calendar) {
            throw this.cannotConvert("Timestamp");
        }

        @Override
        public URL getURL() {
            throw this.cannotConvert("URL");
        }

        @Override
        public NClob getNClob() {
            throw this.cannotConvert("NClob");
        }

        @Override
        public SQLXML getSQLXML() {
            throw this.cannotConvert("SQLXML");
        }

        @Override
        public String getNString() {
            throw this.cannotConvert("NString");
        }

        @Override
        public Reader getNCharacterStream() {
            throw this.cannotConvert("NCharacterStream");
        }

        @Override
        public <T> T getObject(Class<T> type) {
            throw this.cannotConvert("Object (with type)");
        }
    }
}

