/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.remote.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalService
implements Service {
    final Meta meta;

    public LocalService(Meta meta) {
        this.meta = meta;
    }

    private static <E> List<E> list(Iterable<E> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<E> rowList = new ArrayList<E>();
        for (E row : iterable) {
            rowList.add(row);
        }
        return rowList;
    }

    public Service.ResultSetResponse toResponse(Meta.MetaResultSet resultSet) {
        List<Object> list;
        Meta.CursorFactory cursorFactory = resultSet.signature.cursorFactory;
        if (resultSet.iterable != null) {
            list = LocalService.list(resultSet.iterable);
            switch (cursorFactory.style) {
                case ARRAY: {
                    cursorFactory = Meta.CursorFactory.LIST;
                    break;
                }
                case MAP: {
                    break;
                }
                default: {
                    cursorFactory = Meta.CursorFactory.map(cursorFactory.fieldNames);
                    break;
                }
            }
        } else {
            list = this.list2(resultSet);
            cursorFactory = Meta.CursorFactory.LIST;
        }
        Meta.Signature signature = resultSet.signature;
        if (cursorFactory != resultSet.signature.cursorFactory) {
            signature = signature.setCursorFactory(cursorFactory);
        }
        return new Service.ResultSetResponse(resultSet.statementId, resultSet.ownStatement, signature, list);
    }

    private List<List<Object>> list2(Meta.MetaResultSet resultSet) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        return MetaImpl.collect(resultSet.signature.cursorFactory, this.meta.createIterable(new Meta.StatementHandle(resultSet.statementId), resultSet.signature, resultSet.iterable), list);
    }

    @Override
    public Service.ResultSetResponse apply(Service.CatalogsRequest request) {
        Meta.MetaResultSet resultSet = this.meta.getCatalogs();
        return this.toResponse(resultSet);
    }

    @Override
    public Service.ResultSetResponse apply(Service.SchemasRequest request) {
        Meta.MetaResultSet resultSet = this.meta.getSchemas(request.catalog, Meta.Pat.of(request.schemaPattern));
        return this.toResponse(resultSet);
    }

    @Override
    public Service.PrepareResponse apply(Service.PrepareRequest request) {
        Meta.StatementHandle h = new Meta.StatementHandle(request.statementId);
        Meta.Signature signature = this.meta.prepare(h, request.sql, request.maxRowCount);
        return new Service.PrepareResponse(signature);
    }

    @Override
    public Service.ResultSetResponse apply(Service.PrepareAndExecuteRequest request) {
        Meta.StatementHandle h = new Meta.StatementHandle(request.statementId);
        Meta.MetaResultSet resultSet = this.meta.prepareAndExecute(h, request.sql, request.maxRowCount, new Meta.PrepareCallback(){

            @Override
            public Object getMonitor() {
                return LocalService.class;
            }

            @Override
            public void clear() {
            }

            @Override
            public void assign(Meta.Signature signature, Iterable<Object> iterable) {
            }

            @Override
            public void execute() {
            }
        });
        return this.toResponse(resultSet);
    }

    @Override
    public Service.CreateStatementResponse apply(Service.CreateStatementRequest request) {
        Meta.StatementHandle h = this.meta.createStatement(new Meta.ConnectionHandle(request.connectionId));
        return new Service.CreateStatementResponse(h.id);
    }
}

