/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Rsp;

public class RspList<T>
extends HashMap<Address, Rsp<T>>
implements Iterable<Rsp<T>> {
    private static final long serialVersionUID = 6085009056724212815L;

    public RspList() {
    }

    public RspList(int size) {
        super(size);
    }

    public RspList(Map<Address, Rsp<T>> map) {
        this.putAll(map);
    }

    public T getValue(Object key) {
        Rsp rsp = (Rsp)this.get(key);
        return rsp != null ? (T)rsp.getValue() : null;
    }

    public RspList<T> addRsp(Address sender, T retval) {
        Rsp rsp = (Rsp)this.get(sender);
        if (rsp != null) {
            rsp.setValue(retval);
            return this;
        }
        this.put(sender, new Rsp<T>(retval));
        return this;
    }

    public boolean isReceived(Address sender) {
        Rsp rsp = (Rsp)this.get(sender);
        return rsp != null && rsp.wasReceived();
    }

    public int numSuspectedMembers() {
        return (int)this.values().stream().filter(Rsp::wasSuspected).count();
    }

    public int numReceived() {
        return (int)this.values().stream().filter(Rsp::wasReceived).count();
    }

    public T getFirst() {
        Optional<Rsp> retval = this.values().stream().filter(rsp -> rsp.getValue() != null).findFirst();
        return retval.map(Rsp::getValue).orElse(null);
    }

    public List<T> getResults() {
        return this.values().stream().filter(rsp -> rsp.wasReceived() && rsp.getValue() != null).collect(() -> new ArrayList(this.size()), (list, rsp) -> list.add(rsp.getValue()), (l, r) -> {});
    }

    public List<Address> getSuspectedMembers() {
        return this.entrySet().stream().filter(entry -> entry.getValue() != null && ((Rsp)entry.getValue()).wasSuspected()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public boolean isSuspected(Address sender) {
        Rsp rsp = (Rsp)this.get(sender);
        return rsp != null && rsp.wasSuspected();
    }

    @Override
    public String toString() {
        return this.entrySet().stream().collect(StringBuilder::new, (sb, entry) -> sb.append("[").append(entry.getKey()).append(": ").append(entry.getValue()).append("]\n"), (l, r) -> {}).toString();
    }

    boolean contains(Address sender) {
        return this.containsKey(sender);
    }

    @Override
    public Iterator<Rsp<T>> iterator() {
        return this.values().iterator();
    }
}

