/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class RingBuffer<T> {
    protected final T[] buf;
    protected int ri;
    protected int wi;
    protected int count;
    protected final Lock lock = new ReentrantLock();
    protected final Condition not_empty = this.lock.newCondition();
    protected final Condition not_full = this.lock.newCondition();

    public RingBuffer(Class<T> element_type) {
        this.buf = (Object[])Array.newInstance(element_type, 16);
    }

    public RingBuffer(Class<T> element_type, int capacity) {
        int c = Util.getNextHigherPowerOfTwo(capacity);
        this.buf = (Object[])Array.newInstance(element_type, c);
    }

    public T[] buf() {
        return this.buf;
    }

    public int capacity() {
        return this.buf.length;
    }

    public int readIndexLockless() {
        return this.ri;
    }

    public int countLockLockless() {
        return this.count;
    }

    public int readIndex() {
        this.lock.lock();
        try {
            int n = this.ri;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int writeIndex() {
        this.lock.lock();
        try {
            int n = this.wi;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.ri == this.wi;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RingBuffer<T> clear() {
        this.lock.lock();
        try {
            this.wi = 0;
            this.ri = 0;
            this.count = 0;
            Arrays.fill(this.buf, null);
            RingBuffer ringBuffer = this;
            return ringBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RingBuffer<T> put(T element) throws InterruptedException {
        if (element == null) {
            return this;
        }
        this.lock.lock();
        try {
            while (this.count == this.buf.length) {
                this.not_full.await();
            }
            this.buf[this.wi] = element;
            if (++this.wi == this.buf.length) {
                this.wi = 0;
            }
            ++this.count;
            this.not_empty.signal();
            RingBuffer ringBuffer = this;
            return ringBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T take() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.count == 0) {
                this.not_empty.await();
            }
            T el = this.buf[this.ri];
            this.buf[this.ri] = null;
            if (++this.ri == this.buf.length) {
                this.ri = 0;
            }
            --this.count;
            this.not_full.signal();
            T t = el;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int drainTo(Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    public int drainToBlocking(Collection<? super T> c) throws InterruptedException {
        return this.drainToBlocking(c, Integer.MAX_VALUE);
    }

    public int drainTo(Collection<? super T> c, int max_elements) {
        int num = Math.min(this.count, max_elements);
        if (num == 0) {
            return num;
        }
        int read_index = this.ri;
        for (int i = 0; i < num; ++i) {
            int real_index = this.realIndex(read_index + i);
            c.add(this.buf[real_index]);
            this.buf[real_index] = null;
        }
        this.publishReadIndex(num);
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainToBlocking(Collection<? super T> c, int max_elements) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.not_empty.await();
            }
            int n = this.drainTo(c, max_elements);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int drainTo(T[] c) {
        int num = Math.min(this.count, c.length);
        if (num == 0) {
            return num;
        }
        int read_index = this.ri;
        for (int i = 0; i < num; ++i) {
            int real_index = this.realIndex(read_index + i);
            c[i] = this.buf[real_index];
            this.buf[real_index] = null;
        }
        this.publishReadIndex(num);
        return num;
    }

    public int drainToBlocking(T[] c) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.not_empty.await();
            }
            int n = this.drainTo(c);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RingBuffer<T> publishReadIndex(int num_elements_read) {
        this.ri = this.realIndex(this.ri + num_elements_read);
        this.lock.lock();
        try {
            this.count -= num_elements_read;
            this.not_full.signalAll();
            RingBuffer ringBuffer = this;
            return ringBuffer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int waitForMessages() throws InterruptedException {
        return this.waitForMessages(40, null);
    }

    public int waitForMessages(int num_spins, BiConsumer<Integer, Integer> wait_strategy) throws InterruptedException {
        for (int i = 0; i < num_spins && this.count == 0; ++i) {
            if (wait_strategy != null) {
                wait_strategy.accept(i, num_spins);
                continue;
            }
            Thread.yield();
        }
        if (this.count == 0) {
            this._waitForMessages();
        }
        return this.count;
    }

    public void _waitForMessages() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.not_empty.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return String.format("[ri=%d wi=%d size=%d cap=%d]", this.ri, this.wi, this.size(), this.buf.length);
    }

    protected int realIndex(int index) {
        return index & this.buf.length - 1;
    }
}

