/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import org.apache.activemq.artemis.shaded.org.jgroups.BytesMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.MessageFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.ClassConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.pbcast.GMS;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArray;
import org.apache.activemq.artemis.shaded.org.jgroups.util.FastArray;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

@MBean(description="Serializes entire message into the payload of another message")
public class SERIALIZE
extends Protocol {
    protected static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    protected MessageFactory mf;

    @Override
    public void init() throws Exception {
        super.init();
        this.mf = this.getTransport().getMessageFactory();
    }

    @Override
    public Object down(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        ByteArray serialized_msg = null;
        try {
            serialized_msg = Util.messageToBuffer(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Message tmp = new BytesMessage(msg.dest(), serialized_msg).setFlag(msg.getFlags(), false);
        GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
        if (hdr != null) {
            tmp.putHeader(GMS_ID, hdr);
        }
        return this.down_prot.down(tmp);
    }

    @Override
    public Object up(Message msg) {
        try {
            Message ret = this.deserialize(msg);
            return this.up_prot.up(ret);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("failed deserialize message from %s", msg.getSrc()), e);
        }
    }

    @Override
    public void up(MessageBatch batch) {
        FastArray.FastIterator it = (FastArray.FastIterator)batch.iterator();
        while (it.hasNext()) {
            Message msg = (Message)it.next();
            try {
                Message deserialized_msg = this.deserialize(msg);
                it.replace(deserialized_msg);
            }
            catch (Exception e) {
                this.log.error("failed deserializing message", e);
                it.remove();
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected Message deserialize(Message msg) throws Exception {
        try {
            Message ret = Util.messageFromBuffer(msg.getArray(), msg.getOffset(), msg.getLength(), this.mf);
            if (ret.getDest() == null) {
                ret.setDest(msg.getDest());
            }
            if (ret.getSrc() == null) {
                ret.setSrc(msg.getSrc());
            }
            return ret;
        }
        catch (Exception e) {
            throw new Exception(String.format("failed deserialize message from %s", msg.getSrc()), e);
        }
    }
}

