/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.SyncInfo;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsMode;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.UnderFileSystemFactoryRegistry;
import alluxio.underfs.UnderFileSystemWithLogging;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public interface UnderFileSystem
extends Closeable {
    public void cleanup() throws IOException;

    public void connectFromMaster(String var1) throws IOException;

    public void connectFromWorker(String var1) throws IOException;

    public OutputStream create(String var1) throws IOException;

    public OutputStream create(String var1, CreateOptions var2) throws IOException;

    public OutputStream createNonexistingFile(String var1) throws IOException;

    public OutputStream createNonexistingFile(String var1, CreateOptions var2) throws IOException;

    public boolean deleteDirectory(String var1) throws IOException;

    public boolean deleteDirectory(String var1, DeleteOptions var2) throws IOException;

    public boolean deleteExistingDirectory(String var1) throws IOException;

    public boolean deleteExistingDirectory(String var1, DeleteOptions var2) throws IOException;

    public boolean deleteFile(String var1) throws IOException;

    public boolean deleteExistingFile(String var1) throws IOException;

    public boolean exists(String var1) throws IOException;

    @Nullable
    public Pair<AccessControlList, DefaultAccessControlList> getAclPair(String var1) throws IOException;

    @Deprecated
    public long getBlockSizeByte(String var1) throws IOException;

    default public AlluxioConfiguration getConfiguration() throws IOException {
        return InstancedConfiguration.EMPTY_CONFIGURATION;
    }

    public UfsDirectoryStatus getDirectoryStatus(String var1) throws IOException;

    public UfsDirectoryStatus getExistingDirectoryStatus(String var1) throws IOException;

    public List<String> getFileLocations(String var1) throws IOException;

    public List<String> getFileLocations(String var1, FileLocationOptions var2) throws IOException;

    public UfsFileStatus getFileStatus(String var1) throws IOException;

    public UfsFileStatus getExistingFileStatus(String var1) throws IOException;

    public String getFingerprint(String var1);

    public UfsMode getOperationMode(Map<String, UfsMode> var1);

    public List<String> getPhysicalStores();

    public long getSpace(String var1, SpaceType var2) throws IOException;

    public UfsStatus getStatus(String var1) throws IOException;

    public UfsStatus getExistingStatus(String var1) throws IOException;

    public String getUnderFSType();

    public boolean isDirectory(String var1) throws IOException;

    public boolean isExistingDirectory(String var1) throws IOException;

    public boolean isFile(String var1) throws IOException;

    public boolean isObjectStorage();

    public boolean isSeekable();

    @Nullable
    public UfsStatus[] listStatus(String var1) throws IOException;

    @Nullable
    public UfsStatus[] listStatus(String var1, ListOptions var2) throws IOException;

    public boolean mkdirs(String var1) throws IOException;

    public boolean mkdirs(String var1, MkdirsOptions var2) throws IOException;

    public InputStream open(String var1) throws IOException;

    public InputStream open(String var1, OpenOptions var2) throws IOException;

    public InputStream openExistingFile(String var1) throws IOException;

    public InputStream openExistingFile(String var1, OpenOptions var2) throws IOException;

    public boolean renameDirectory(String var1, String var2) throws IOException;

    public boolean renameRenamableDirectory(String var1, String var2) throws IOException;

    public boolean renameFile(String var1, String var2) throws IOException;

    public boolean renameRenamableFile(String var1, String var2) throws IOException;

    public AlluxioURI resolveUri(AlluxioURI var1, String var2);

    public void setAclEntries(String var1, List<AclEntry> var2) throws IOException;

    public void setMode(String var1, short var2) throws IOException;

    public void setOwner(String var1, String var2, String var3) throws IOException;

    public boolean supportsFlush() throws IOException;

    public boolean supportsActiveSync();

    public SyncInfo getActiveSyncInfo() throws IOException;

    public void startSync(AlluxioURI var1) throws IOException;

    public void stopSync(AlluxioURI var1) throws IOException;

    public boolean startActiveSyncPolling(long var1) throws IOException;

    public boolean stopActiveSyncPolling() throws IOException;

    public static enum SpaceType {
        SPACE_TOTAL(0),
        SPACE_FREE(1),
        SPACE_USED(2);

        private final int mValue;

        private SpaceType(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);

        private Factory() {
        }

        public static UnderFileSystem create(String path, AlluxioConfiguration conf) {
            return Factory.create(path, UnderFileSystemConfiguration.defaults(conf));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static UnderFileSystem create(String path, UnderFileSystemConfiguration ufsConf) {
            List<UnderFileSystemFactory> factories = UnderFileSystemFactoryRegistry.findAll(path, ufsConf);
            if (factories.isEmpty()) {
                throw new IllegalArgumentException("No Under File System Factory found for: " + path);
            }
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            for (UnderFileSystemFactory factory : factories) {
                ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(factory.getClass().getClassLoader());
                    UnderFileSystemWithLogging underFileSystemWithLogging = new UnderFileSystemWithLogging(path, factory.create(path, ufsConf), ufsConf);
                    return underFileSystemWithLogging;
                }
                catch (Throwable e) {
                    errors.add(e);
                    LOG.warn("Failed to create UnderFileSystem by factory {}: {}", (Object)factory, (Object)e.getMessage());
                }
                finally {
                    Thread.currentThread().setContextClassLoader(previousClassLoader);
                }
            }
            IllegalArgumentException e = new IllegalArgumentException(String.format("Unable to create an UnderFileSystem instance for path: %s", path));
            for (Throwable t : errors) {
                e.addSuppressed(t);
            }
            throw e;
        }

        public static UnderFileSystem createForRoot(AlluxioConfiguration conf) {
            String ufsRoot = conf.get(PropertyKey.MASTER_MOUNT_TABLE_ROOT_UFS);
            boolean readOnly = conf.getBoolean(PropertyKey.MASTER_MOUNT_TABLE_ROOT_READONLY);
            boolean shared = conf.getBoolean(PropertyKey.MASTER_MOUNT_TABLE_ROOT_SHARED);
            Map<String, String> ufsConf = conf.getNestedProperties(PropertyKey.MASTER_MOUNT_TABLE_ROOT_OPTION);
            return Factory.create(ufsRoot, UnderFileSystemConfiguration.defaults(conf).setReadOnly(readOnly).setShared(shared).createMountSpecificConf(ufsConf));
        }
    }
}

