/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.CloseableResource;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public abstract class CloseableIterator<T>
extends CloseableResource<Iterator<T>> {
    public CloseableIterator(Iterator<T> iterator) {
        super(iterator);
    }

    public static <T> CloseableIterator<T> noopCloseable(Iterator<? extends T> iterator) {
        return new CloseableIterator(iterator){

            @Override
            public void close() {
            }
        };
    }

    public static <T> CloseableIterator<T> concat(CloseableIterator<T> a, CloseableIterator<T> b) {
        return CloseableIterator.concat(Lists.newArrayList((Object[])new CloseableIterator[]{a, b}));
    }

    public static <T> CloseableIterator<T> concat(final List<CloseableIterator<T>> iterators) {
        Iterator it = Iterators.concat(iterators.stream().map(CloseableResource::get).iterator());
        return new CloseableIterator<T>(Iterators.concat((Iterator[])new Iterator[]{it})){

            @Override
            public void close() {
                Closer c = Closer.create();
                iterators.forEach(arg_0 -> ((Closer)c).register(arg_0));
                try {
                    c.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to close iterator", e);
                }
            }
        };
    }
}

