/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.worker.block.io.BlockWriter;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.WritableByteChannel;

public final class MockBlockWriter
extends BlockWriter {
    private final ByteArrayOutputStream mOutputStream = new ByteArrayOutputStream();
    private long mPosition;

    public void close() throws IOException {
        this.mOutputStream.close();
        this.mPosition = -1L;
    }

    public long append(ByteBuffer inputBuf) throws IOException {
        byte[] bytes = new byte[inputBuf.remaining()];
        inputBuf.get(bytes);
        this.mOutputStream.write(bytes);
        this.mPosition += (long)bytes.length;
        return bytes.length;
    }

    public long append(ByteBuf buf) throws IOException {
        long bytesWritten = buf.readBytes(this.getChannel(), buf.readableBytes());
        this.mPosition += bytesWritten;
        return bytesWritten;
    }

    public long append(DataBuffer buffer) throws IOException {
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes, 0, bytes.length);
        this.mOutputStream.write(bytes);
        this.mPosition += (long)bytes.length;
        return bytes.length;
    }

    public GatheringByteChannel getChannel() {
        return new GatheringByteChannel(){
            WritableByteChannel mChannel;
            {
                this.mChannel = Channels.newChannel(MockBlockWriter.this.mOutputStream);
            }

            @Override
            public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                long b = 0L;
                for (int i = offset; i < offset + length; ++i) {
                    b += (long)this.mChannel.write(srcs[i]);
                }
                return b;
            }

            @Override
            public long write(ByteBuffer[] srcs) throws IOException {
                return this.write(srcs, 0, srcs.length);
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return this.mChannel.write(src);
            }

            @Override
            public boolean isOpen() {
                return this.mChannel.isOpen();
            }

            @Override
            public void close() throws IOException {
                this.mChannel.close();
            }
        };
    }

    public long getPosition() {
        return this.mPosition;
    }

    public byte[] getBytes() {
        return this.mOutputStream.toByteArray();
    }
}

