/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.worker.block.io.BlockReader;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public final class MockBlockReader
extends BlockReader {
    private final byte[] mBytes;

    public MockBlockReader(byte[] bytes) {
        this.mBytes = bytes;
    }

    public void close() {
    }

    public ByteBuffer read(long offset, long length) {
        return ByteBuffer.wrap(this.mBytes, (int)offset, (int)length);
    }

    public int transferTo(ByteBuf buf) {
        int remaining = buf.readableBytes();
        return buf.writeBytes(this.mBytes).readableBytes() - remaining;
    }

    public boolean isClosed() {
        return false;
    }

    public long getLength() {
        return this.mBytes.length;
    }

    public ReadableByteChannel getChannel() {
        return Channels.newChannel(new ByteArrayInputStream(this.mBytes));
    }

    public String getLocation() {
        return "mock";
    }
}

