/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.util.io.BufferUtils;
import alluxio.worker.block.io.LocalFileBlockWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public final class LocalFileBlockWriterTest {
    private static final int TEST_BLOCK_SIZE = 1024;
    private LocalFileBlockWriter mWriter;
    private String mTestFilePath;
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Before
    public void before() throws Exception {
        this.mTestFilePath = this.mFolder.newFile().getAbsolutePath();
        this.mWriter = new LocalFileBlockWriter(this.mTestFilePath);
    }

    @After
    public void after() throws Exception {
        this.mWriter.close();
    }

    @Test
    public void appendByteBuf() throws Exception {
        ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuffer)BufferUtils.getIncreasingByteBuffer((int)1024));
        buffer.markReaderIndex();
        Assert.assertEquals((long)1024L, (long)this.mWriter.append(buffer));
        buffer.resetReaderIndex();
        Assert.assertEquals((long)1024L, (long)this.mWriter.append(buffer));
        this.mWriter.close();
        Assert.assertEquals((long)2048L, (long)new File(this.mTestFilePath).length());
        ByteBuffer result = ByteBuffer.wrap(Files.readAllBytes(Paths.get(this.mTestFilePath, new String[0])));
        result.position(0).limit(1024);
        BufferUtils.equalIncreasingByteBuffer((int)0, (int)1024, (ByteBuffer)result.slice());
        result.position(1024).limit(2048);
        BufferUtils.equalIncreasingByteBuffer((int)0, (int)1024, (ByteBuffer)result.slice());
    }

    @Test
    public void append() throws Exception {
        ByteBuffer buf = BufferUtils.getIncreasingByteBuffer((int)1024);
        Assert.assertEquals((long)1024L, (long)this.mWriter.append(buf));
        Assert.assertEquals((long)1024L, (long)this.mWriter.append(buf));
        this.mWriter.close();
        Assert.assertEquals((long)2048L, (long)new File(this.mTestFilePath).length());
        ByteBuffer result = ByteBuffer.wrap(Files.readAllBytes(Paths.get(this.mTestFilePath, new String[0])));
        result.position(0).limit(1024);
        BufferUtils.equalIncreasingByteBuffer((int)0, (int)1024, (ByteBuffer)result.slice());
        result.position(1024).limit(2048);
        BufferUtils.equalIncreasingByteBuffer((int)0, (int)1024, (ByteBuffer)result.slice());
    }

    @Test
    public void close() throws Exception {
        ByteBuffer buf = BufferUtils.getIncreasingByteBuffer((int)1024);
        Assert.assertEquals((long)1024L, (long)this.mWriter.append(buf));
        this.mWriter.close();
        this.mThrown.expect(IOException.class);
        this.mWriter.append(buf);
    }
}

