/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.util.io.BufferUtils;
import alluxio.worker.block.io.LocalFileBlockReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class LocalFileBlockReaderTest {
    private static final long TEST_BLOCK_SIZE = 1024L;
    private LocalFileBlockReader mReader;
    @Rule
    public TemporaryFolder mFolder = new TemporaryFolder();
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Before
    public void before() throws Exception {
        String testFilePath = this.mFolder.newFile().getAbsolutePath();
        byte[] buffer = BufferUtils.getIncreasingByteArray((int)1024);
        BufferUtils.writeBufferToFile((String)testFilePath, (byte[])buffer);
        this.mReader = new LocalFileBlockReader(testFilePath);
    }

    @Test
    public void getChannel() throws Exception {
        ReadableByteChannel channel = this.mReader.getChannel();
        Assert.assertNotNull((Object)channel);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        int bytesRead = channel.read(buffer);
        Assert.assertEquals((long)1024L, (long)bytesRead);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)1024, (ByteBuffer)buffer));
    }

    @Test
    public void getLocation() {
        Assert.assertEquals((Object)this.mReader.getFilePath(), (Object)this.mReader.getLocation());
    }

    @Test
    public void getLength() {
        Assert.assertEquals((long)1024L, (long)this.mReader.getLength());
    }

    @Test
    public void readWithInvalidArgument() throws Exception {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage("exceeding fileSize");
        this.mReader.read(1023L, 2L);
    }

    @Test
    public void read() throws Exception {
        ByteBuffer buffer = this.mReader.read(0L, 256L);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)256, (ByteBuffer)buffer));
        buffer = this.mReader.read(0L, 1024L);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)1024, (ByteBuffer)buffer));
        int length = -1;
        buffer = this.mReader.read(0L, (long)length);
        Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)0, (int)1024, (ByteBuffer)buffer));
    }

    @Test
    public void close() throws Exception {
        this.mReader.close();
        this.mThrown.expect(IOException.class);
        this.mReader.read(0L, 1024L);
    }
}

