/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.GrpcUtils;
import alluxio.util.CommonUtils;
import alluxio.wire.TieredIdentity;
import alluxio.wire.TieredIdentityTest;
import alluxio.wire.WorkerNetAddress;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class WorkerNetAddressTest {
    @Test
    public void json() throws Exception {
        WorkerNetAddress workerNetAddress = WorkerNetAddressTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        WorkerNetAddress other = (WorkerNetAddress)mapper.readValue(mapper.writeValueAsBytes((Object)workerNetAddress), WorkerNetAddress.class);
        this.checkEquality(workerNetAddress, other);
    }

    @Test
    public void proto() {
        WorkerNetAddress workerNetAddress = WorkerNetAddressTest.createRandom();
        WorkerNetAddress other = GrpcUtils.fromProto((alluxio.grpc.WorkerNetAddress)GrpcUtils.toProto((WorkerNetAddress)workerNetAddress));
        this.checkEquality(workerNetAddress, other);
    }

    public void checkEquality(WorkerNetAddress a, WorkerNetAddress b) {
        Assert.assertEquals((Object)a.getHost(), (Object)b.getHost());
        Assert.assertEquals((long)a.getRpcPort(), (long)b.getRpcPort());
        Assert.assertEquals((long)a.getDataPort(), (long)b.getDataPort());
        Assert.assertEquals((long)a.getWebPort(), (long)b.getWebPort());
        Assert.assertEquals((Object)a.getTieredIdentity(), (Object)b.getTieredIdentity());
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static WorkerNetAddress createRandom() {
        WorkerNetAddress result = new WorkerNetAddress();
        Random random = new Random();
        String host = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        int rpcPort = random.nextInt();
        int dataPort = random.nextInt();
        int webPort = random.nextInt();
        TieredIdentity identity = TieredIdentityTest.createRandomTieredIdentity();
        result.setHost(host);
        result.setRpcPort(rpcPort);
        result.setDataPort(dataPort);
        result.setWebPort(webPort);
        result.setTieredIdentity(identity);
        return result;
    }
}

