/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.GrpcUtils;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import alluxio.wire.WorkerNetAddressTest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class WorkerInfoTest {
    @Test
    public void json() throws Exception {
        WorkerInfo workerInfo = WorkerInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        WorkerInfo other = (WorkerInfo)mapper.readValue(mapper.writeValueAsBytes((Object)workerInfo), WorkerInfo.class);
        this.checkEquality(workerInfo, other);
    }

    @Test
    public void proto() {
        WorkerInfo workerInfo = WorkerInfoTest.createRandom();
        WorkerInfo other = GrpcUtils.fromProto((alluxio.grpc.WorkerInfo)GrpcUtils.toProto((WorkerInfo)workerInfo));
        this.checkEquality(workerInfo, other);
    }

    @Test
    public void lastContactSecComparator() {
        Assert.assertTrue((WorkerInfoTest.compareLostWorkersWithTimes(0, 1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WorkerInfoTest.compareLostWorkersWithTimes(1, 0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WorkerInfoTest.compareLostWorkersWithTimes(1, 1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WorkerInfoTest.compareLostWorkersWithTimes(-1, 1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WorkerInfoTest.compareLostWorkersWithTimes(1, -1) > 0 ? 1 : 0) != 0);
    }

    public void checkEquality(WorkerInfo a, WorkerInfo b) {
        Assert.assertEquals((long)a.getId(), (long)b.getId());
        Assert.assertEquals((Object)a.getAddress(), (Object)b.getAddress());
        Assert.assertEquals((long)a.getLastContactSec(), (long)b.getLastContactSec());
        Assert.assertEquals((long)a.getCapacityBytes(), (long)b.getCapacityBytes());
        Assert.assertEquals((long)a.getUsedBytes(), (long)b.getUsedBytes());
        Assert.assertEquals((long)a.getStartTimeMs(), (long)b.getStartTimeMs());
        Assert.assertEquals((Object)a.getState(), (Object)b.getState());
        Assert.assertEquals((Object)a.getCapacityBytesOnTiers(), (Object)b.getCapacityBytesOnTiers());
        Assert.assertEquals((Object)a.getUsedBytesOnTiers(), (Object)b.getUsedBytesOnTiers());
        Assert.assertEquals((Object)a, (Object)b);
    }

    private static int compareLostWorkersWithTimes(int time1, int time2) {
        WorkerInfo.LastContactSecComparator comparator = new WorkerInfo.LastContactSecComparator();
        WorkerInfo worker1 = WorkerInfoTest.createRandom();
        WorkerInfo worker2 = WorkerInfoTest.createRandom();
        worker1.setLastContactSec(time1);
        worker2.setLastContactSec(time2);
        return comparator.compare(worker1, worker2);
    }

    public static WorkerInfo createRandom() {
        WorkerInfo result = new WorkerInfo();
        Random random = new Random();
        long id = random.nextLong();
        WorkerNetAddress address = WorkerNetAddressTest.createRandom();
        int lastContactSec = random.nextInt();
        long capacityBytes = random.nextLong();
        long usedBytes = random.nextLong();
        long startTimeMs = random.nextLong();
        HashMap<String, Long> capacityBytesOnTiers = new HashMap<String, Long>();
        capacityBytesOnTiers.put("MEM", capacityBytes);
        HashMap<String, Long> usedBytesOnTiers = new HashMap<String, Long>();
        usedBytesOnTiers.put("MEM", usedBytes);
        String state = random.nextInt(1) == 1 ? "In Service" : "Out of Service";
        result.setId(id);
        result.setAddress(address);
        result.setLastContactSec(lastContactSec);
        result.setCapacityBytes(capacityBytes);
        result.setUsedBytes(usedBytes);
        result.setStartTimeMs(startTimeMs);
        result.setState(state);
        result.setCapacityBytesOnTiers(capacityBytesOnTiers);
        result.setUsedBytesOnTiers(usedBytesOnTiers);
        return result;
    }
}

